#!/bin/sh
# Gloria eo in caelo.
#
#
# LICENSE: GNU GPL 2.0.
# snsr.sh(1) environmental status report wrapper for sh(1).
# Copyright (C) 2024-25, Marc Fege alias 13MDF / DN9MF.
# E-Mail: 13mdf@fege.net
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License version 2
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
# MA 02110-1301, USA.
#
#
# DESCRIPTION:
# Environmental status report wrapper.  Prints out env. sensor data.
# It is possible to state additional cutting of lines to refine output.
#
#
# EXAMPLES:
# 1.: prints out environmental sensor data once:
#       ./snsr.sh
# 2.: prints out environmental sensor data every 3 seconds:
#       ./snsr.sh 3
# 3.: alternative way of stating the delay in seconds:
#       ./snsr.sh -3
# 4.: as 2., but shows only the first 9 lines:
#       ./snsr.sh 3 9
# 5.: as 4., but cuts all but the first 9 and then it's last 7 lines:
#       ./snsr.sh 3 9 7
# 6.: as 2., but shows only the last 7 lines:
#       ./snsr.sh 3 - 7


CP='Copyright (C) 2024-25, Marc Fege.'
PN="`basename $0`"
EM='13mdf@fege.net'
VS='1.1'
DT='2025-02-24'
CPQRACB='13MDF'
CPQRAHAM='DN9MF'
NET='https://www.fege.net/software'
MB='[none]'

EA=' ERROR: too many arguments!  Max: 3.'
ES=' ERROR: System unknown!'
EO=" ERROR: '$1': unknown option specified!"
EW=' ERROR: wrong value stated!'

SYS="`uname -s`"

FuncHelpShort() {
echo "CALLING: $PN [seconds] [head lines] [tail lines]
  -h, --help     Prints out this help.
  -v, --version  Version, date, license.

DESCRIPTION:
  Environmental status report wrapper.  Prints out env. sensor data.
  It is possible to state additional cutting of lines to refine output.

EXAMPLES:
  1.: prints out environmental sensor data once:
        $PN
  2.: prints out environmental sensor data every 3 seconds:
        $PN 3
  3.: alternative way of stating the delay in seconds:
        $PN -3
  4.: as 2., but shows only the first 9 lines:
        $PN 3 9
  5.: as 4., but cuts all but the first 9 and then it's last 7 lines:
        $PN 3 9 7
  6.: as 2., but shows only the last 7 lines:
        $PN 3 - 7"
}

FuncVersion() {
echo "VERSION, AUTHOR, COPYRIGHT AND CONTACT

Version: $VS, date: $DT.
$CP

  This program is provided by the terms
  of the 'GNU GPL' in version 2.
  The original text of the licence could
  be obtained from:
    http://www.gnu.org/licenses/old~
    -licenses/gpl-2.0

  Internet:
    $NET
  Mailbox (V.34):
    $MB
  Contact:
    E-mail   : $EM
    QRA (CB) : $CPQRACB
    QRA (HAM): $CPQRAHAM"
}

FuncEW() {
	echo "$EW" >&2 ; FuncHelpShort >&2 ; exit 1
}

CMD() {
	case $SYS in
		Linux)		sensors ;;
		NetBSD)		envstat ;;
		FreeBSD)	sysctl -a | grep -i temperature ;;
		*)		echo "$ES" >&2 ; exit 1 ;;
	esac
}

if [ "$#" -gt '3' ] ; then echo "$EA" >&2 ; FuncHelpShort >&2 ; exit 1
else
S="`echo $1 | tr -d '-'`"
H="`echo $2 | tr -d '-'`"
T="`echo $3 | tr -d '-'`"
case $1 in
	-h*|--help*)	FuncHelpShort ;;
	-v*|--version*)	FuncVersion ;;
	''|-)
		case $2 in
			''|-)
				case $3 in
					''|-)		CMD ;;
					[1-9]*|-[1-9]*)	CMD | tail -$T;;
					*)		FuncEW ;;
				esac
				;;
			[1-9]*|-[1-9]*)
				case $3 in
					''|-)	CMD | head -$H ;;
					[1-9]*|-[1-9]*)
						CMD | head -$H \
						| tail -$T ;;
					*)	FuncEW ;;
				esac
				;;
			*)	FuncEW ;;
		esac
		;;
	[1-9]*|-[1-9]*)
		case $2 in
			''|-)
				case $3 in
					''|-)
						while [ "$?" = 0 ] ; do
							clear ; CMD \
							&& sleep "$S"
						done
						;;
					[1-9]*|-[1-9]*)
						while [ "$?" = 0 ] ; do
							clear ; CMD \
							| tail -$T \
							&& sleep "$S"
						done
						;;
					*)	FuncEW ;;
				esac
				;;
			[1-9]*|-[1-9]*)
				case $3 in
					''|-)
						while [ "$?" = 0 ] ; do
							clear ; CMD \
							| head -$H \
							&& sleep "$S"
						done
						;;
					[1-9]*|-[1-9]*)
						while [ "$?" = 0 ] ; do
							clear ; CMD \
							| head -$H \
							| tail -$T \
							&& sleep "$S"
						done
						;;
					*)	FuncEW ;;
				esac
				;;
			*)	FuncEW ;;
		esac
		;;
	-*|--*)	echo "$EO" >&2 ; FuncHelpShort >&2 ; exit 1 ;;
	*)	FuncEW ;;
esac
fi
