#!/bin/sh
# Gloria eo in caelo.
#
#
# LICENSE: GNU GPL 2.0.
# makewords(1) Word preparation for checking against a dictionary.
# Copyright (C) 2024-25, Marc Fege alias 13MDF / DN9MF.
# E-Mail: 13mdf@fege.net
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License version 2
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
# MA 02110-1301, USA.
#
#
# DESCRIPTION:
# Reads a text either from a file given in $1 or from stdin and prepares
# it for comparing against a dictionary.  The tool prints out unique
# lowercase and depunctuated words one word per line.
#
#
# EXAMPLES:
# 1.: Reads from stdin, writes to stdout:
#       ./makewords.sh
# 2.: Reads 'file.txt', writes to stdout:
#       ./makewords.sh file.txt
# 3.: Reads 'file.txt', writes to 'fileout.txt'.
#       ./makewords.sh file.txt fileout.txt
# 4.: Reads from stdin, writes to 'fileout.txt':
#     ./makewords.sh - fileout.txt


CP='Copyright (C) 2025, Marc Fege.'
PN="`basename $0`"
EM='13mdf@fege.net'
VS='1.2'
DT='2025-05-16'
CPQRACB='13MDF'
CPQRAHAM='DN9MF'
NET='https://www.fege.net/software'
MB='[none]'

EA=' ERROR: too many arguments!  Max: 2.'
EF=" ERROR: '$1': no such file!"
EI=" ERROR: '$1': files in "'$1 and $2 identical!'
EO=" ERROR: '$1': unknown option specified!"


FuncHelpShort() {
echo "CALLING: $PN [FileIn] [FileOut]
  -h, --help     Prints out this help.
  -v, --version  Version, date, license.

DESCRIPTION:
  Reads a text either from a file given in "'$1'" or from stdin and \
prepares
  it for comparing against a dictionary.  The tool prints out unique
  lowercase and depunctuated words one word per line.

EXAMPLES:
  1.: Reads from stdin, writes to stdout:
        $PN
  2.: Reads 'file.txt', writes to stdout:
        $PN file.txt
  3.: Reads 'file.txt', writes to 'fileout.txt':
        $PN file.txt fileout.txt
  4.: Reads from stdin, writes to 'fileout.txt':
        $PN - fileout.txt"
}

FuncVersion() {
echo "VERSION, AUTHOR, COPYRIGHT AND CONTACT

Version: $VS, date: $DT.
$CP

  This program is provided by the terms
  of the 'GNU GPL' in version 2.
  The original text of the licence could
  be obtained from:
    http://www.gnu.org/licenses/old~
    -licenses/gpl-2.0

  Internet:
    $NET
  Mailbox (V.34):
    $MB
  Contact:
    E-mail   : $EM
    QRA (CB) : $CPQRACB
    QRA (HAM): $CPQRAHAM"
}

FuncMakewords() {
	tr '[:space:]' '\n' | sed '/^$/d' | tr '[:upper:]' '[:lower:]' \
	| tr -d '[:punct:]' | sort -f | uniq
}

if [ "$#" -gt '2' ] ; then echo "$EA" >&2 ; FuncHelpShort >&2 ; exit 1
	elif [ -r "$1" -a "$2" ] ; then
		case $2 in
			-|'')	FuncMakewords < "$1" ;;
			*)
				if [ "$1" != "$2" ] ; then
					FuncMakewords < "$1" > "$2"
					else
						echo "$EI" >&2
						FuncHelpShort >&2
						exit 1
				fi
				;;
		esac
	elif [ -r "$1" ] ; then	FuncMakewords < "$1"
	else
	case $1 in
		-h*|--help*)	FuncHelpShort ;;
		-v*|--version*)	FuncVersion ;;
		-|'')
		case $2 in
			-|'')	FuncMakewords ;;
			*)	FuncMakewords > "$2" ;;
		esac
		;;
		-*|--*)	echo "$EO" >&2 ; FuncHelpShort >&2 ; exit 1 ;;
		*)	echo "$EF" >&2 ; FuncHelpShort >&2 ; exit 1 ;;
	esac
fi
