#!/bin/sh
# Gloria eo in caelo.
#
#
# LICENSE: GNU GPL 2.0.
# lc(1) Count line length and line numbers.
# Copyright (C) 2025, Marc Fege alias 13MDF / DN9MF.
# E-Mail: 13mdf@fege.net
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License version 2
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
# MA 02110-1301, USA.
#
#
# DESCRIPTION:
# Reads a text either from a file given in $1 or from stdin and counts
# line length and line numbers, as well as sort output as desired.
#
#
# EXAMPLES:
# 1.: Reads from stdin, writes to stdout and prints line length and line
#     number:
#       lc
# 2.: as 1 plus sorts output numerically by the longest line and prints
#     output:
#       lc -lnps
# 3.: as 1, but reading from 'file.txt':
#       lc file.txt
# 4.: as 3, but reading from 'file.txt':
#       lc -lnps file.txt


CP='Copyright (C) 2025, Marc Fege.'
PN="`basename $0`"
EM='13mdf@fege.net'
VS='1.3'
DT='2025-05-18'
CPQRACB='13MDF'
CPQRAHAM='DN9MF'
NET='https://www.fege.net/software'
MB='[none]'

EAn=" ERROR: no arguments allowed with '$1'!"
EA3=' ERROR: too many arguments!  Max: 3.'
EA1=' ERROR: too many arguments!  Max: 1.'
EF=" ERROR: '$1': no such file!"
El=" ERROR: '-l' not possible with '-L'!"
EL=" ERROR: '-L' no possible with '-l'!"
EO=" ERROR: '$1': unknown option specified!"
Er=" ERROR: '-r' not possible with '-s'!"
Es=" ERROR: '-s' no possible with '-r'!"


FuncHelpShort() {
echo "CALLING: $PN -[lL]np[sr] [FileIn]
  -h, --help     Prints out this help.
  -v, --version  Version, date, license.

  -l | -L        Print line length / print only longest line(s).
  -n             Print line number.
  -p             Print raw input.
  -s | -r        Numerical sort / reverse numerical sort.

DESCRIPTION:
  Count line length and line numbers, as well as sort output as desired.

EXAMPLES:
  1.: Reads from stdin, writes to stdout and prints line length and line
      number:
        $PN
  2.: as 1 plus sorts output numerically by the longest line and prints
        output:
        $PN -lnps
  3.: as 1, but reading from 'file.txt':
        $PN file.txt
  4.: as 3, but reading from 'file.txt':
        $PN -lnps file.txt"
}

FuncVersion() {
echo "VERSION, AUTHOR, COPYRIGHT AND CONTACT

Version: $VS, date: $DT.
$CP

  This program is provided by the terms
  of the 'GNU GPL' in version 2.
  The original text of the licence could
  be obtained from:
    http://www.gnu.org/licenses/old~
    -licenses/gpl-2.0

  Internet:
    $NET
  Mailbox (V.34):
    $MB
  Contact:
    E-mail   : $EM
    QRA (CB) : $CPQRACB
    QRA (HAM): $CPQRAHAM"
}

Funcp() {
	cat
}

Funcn() {
	awk '{printf "%6.0Lf\n", NR}'
}

Funcnp() {
	awk '{printf "%6.0Lf\t%s\n", NR, $0}'
}

Funcl() {
	expand | awk '{printf "%6.0Lf\n", length}'
}

Funclp() {
	expand | awk '{printf "%6.0Lf\t%s\n", length, $0}'
}

Funcln() {
	expand | awk '{printf "%6.0Lf\t%6.0Lf\n", length, NR}'
}

Funclnp() {
	expand | awk '{printf "%6.0Lf\t%6.0Lf\t%s\n", length, NR, $0}'
}

FuncL() {
	expand | awk 'l < length {delete p; l = length}
			l == length {p[NR] = $0}
			END {for (n in p)
			printf "%6.0Lf\n", n}'
}

FuncLp() {
	expand | awk 'l < length {delete p; l = length}
			l == length {p[NR] = $0}
			END {for (n in p)
			printf "%6.0Lf\t%s\n", n, p[n]}'
}

FuncLn() {
	expand | awk 'l < length {delete p; l = length}
			l == length {p[NR] = $0}
			END {for (n in p)
			printf "%6.0Lf\t%6.0Lf\n", l, n}'
}

FuncLnp() {
	expand | awk 'l < length {delete p; l = length}
			l == length {p[NR] = $0}
			END {for (n in p)
			printf "%6.0Lf\t%6.0Lf\t%s\n", l, n, p[n]}'
}

FuncSort() {
	if [ "$Fr" -eq '1' ] ; then
		sort -rf
	elif [ "$Fs" -eq '1' -o "$FL" -eq '1' ] ; then
		sort -f
	else	cat
	fi
}

FuncSw() {

	# check matrix:
	# L	l	n	p	Func
	#
	# 0	0	0	0	Funcln
	#
	# 0	0	0	1	Funccp
	# 0	0	1	0	Funccn
	# 0	0	1	1	Funccnp
	#
	# 0	1	0	0	Funcl
	# 0	1	0	1	Funclp
	# 0	1	1	0	Funcln
	# 0	1	1	1	Funclnp
	#
	# 1	0	0	0	FuncL
	# 1	0	0	1	FuncLp
	# 1	0	1	0	FuncLn
	# 1	0	1	1	FuncLnp
	#
	# 1	1	0	0	- [illegal]
	# 1	1	0	1	- [illegal]
	# 1	1	1	0	- [illegal]
	# 1	1	1	1	- [illegal]

	if [ "$FL" -eq '0' -a "$Fl" -eq '0' \
		-a "$Fn" -eq '0' -a "$Fp" -eq '1' ] ; then
		Funcp
	elif [ "$FL" -eq '0' -a  "$Fl" -eq '0' \
		-a "$Fn" -eq '1' -a "$Fp" -eq '0' ] ; then
		Funcn
	elif [ "$FL" -eq '0' -a  "$Fl" -eq '0' \
		-a "$Fn" -eq '1' -a "$Fp" -eq '1' ] ; then
		Funcnp
	elif [ "$FL" -eq '0' -a  "$Fl" -eq '1' \
		-a "$Fn" -eq '0' -a "$Fp" -eq '0' ] ; then
		Funcl
	elif [ "$FL" -eq '0' -a  "$Fl" -eq '1' \
		-a "$Fn" -eq '0' -a "$Fp" -eq '1' ] ; then
		Funclp
	elif [ "$FL" -eq '0' -a  "$Fl" -eq '1' \
		-a "$Fn" -eq '1' -a "$Fp" -eq '0' ] ; then
		Funcln
	elif [ "$FL" -eq '0' -a  "$Fl" -eq '1' \
		-a "$Fn" -eq '1' -a "$Fp" -eq '1' ] ; then
		Funclnp
	elif [ "$FL" -eq '1' -a  "$Fl" -eq '0' \
		-a "$Fn" -eq '0' -a "$Fp" -eq '0' ] ; then
		FuncL
	elif [ "$FL" -eq '1' -a  "$Fl" -eq '0' \
		-a "$Fn" -eq '0' -a "$Fp" -eq '1' ] ; then
		FuncLp
	elif [ "$FL" -eq '1' -a  "$Fl" -eq '0' \
		-a "$Fn" -eq '1' -a "$Fp" -eq '0' ] ; then
		FuncLn
	elif [ "$FL" -eq '1' -a  "$Fl" -eq '0' \
		-a "$Fn" -eq '1' -a "$Fp" -eq '1' ] ; then
		FuncLnp
	else	Funcln
	fi | FuncSort
}


Fl=0
FL=0
Fn=0
Fp=0
Fr=0
Fs=0
if [ "$#" -gt '3' ] ; then echo "$EA3" >&2 ; FuncHelpShort >&2 ; exit 1
else
	case $1 in
		-h*|--help*|-\?*|\?)
			if [ "$#" -gt '1' ] ; then
				echo "$EAn" >&2 ; FuncHelpShort >&2
				exit 1
			else
				FuncHelpShort ; exit
			fi
			;;
		-v*|--version*)
			if [ "$#" -gt '1' ] ; then
				echo "$EAn" >&2 ; FuncHelpShort >&2
				exit 1
			else
				FuncVersion ; exit
			fi
			;;
		*)
			while getopts lLnprs OPT ; do
				case $OPT in
					l)	Fl=1
						if [ $FL -eq 1 ] ; then
							echo "$El" >&2
							exit 1
						fi
						;;
					L)	FL=1
						if [ $Fl -eq 1 ] ; then
							echo "$EL" >&2
							exit 1
						fi
						;;
					n)	Fn=1 ;;
					p)	Fp=1 ;;
					r)	Fr=1
						if [ $Fs -eq 1 ] ; then
							echo "$Er" >&2
							exit 1
						fi
						;;
					s)	Fs=1
						if [ $Fr -eq 1 ] ; then
							echo "$Es" >&2
							exit 1
						fi
						;;
					*)	FuncHelpShort >&2
						exit 1 ;;
				esac
			done
			shift $((OPTIND - 1))
			;;
	esac
fi
if [ "$#" -gt '1' ] ; then echo "$EA1" >&2 ; FuncHelpShort >&2 ; exit 1
elif [ -r "$1" ] ; then
	FuncSw < "$1"
	else
	case $1 in
		-|'')	FuncSw ;;
		-*|--*)	echo "$EO" >&2 ; FuncHelpShort >&2 ; exit 1 ;;
		*)	echo "$EF" >&2 ; FuncHelpShort >&2 ; exit 1 ;;
	esac
fi
