#!/bin/sh
# Gloria eo in caelo.
#
#
# LICENSE: GNU GPL 2.0.
# fld(1) Folding text using fold(1), but removes trailing spaces.
# Copyright (C) 2025, Marc Fege alias 13MDF / DN9MF.
# E-Mail: 13mdf@fege.net
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License version 2
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
# MA 02110-1301, USA.
#
#
# DESCRIPTION:
# Reads a text either from a file given in $1 or from stdin and folds
# it using fold(1) and removes trailing spaces using sed(1).
#
#
# EXAMPLES:
# 1.: Reads from stdin, writes to stdout, folds after 80 chars:
#       $PN
# 2.: Reads 'file.txt', writes to stdout, folds after 80 chars:
#       $PN file.txt
# 3.: Reads from stdin, writes to stdout, folds after 72 chars:
#       $PN -sw 72
# 4.: Reads 'file.txt', writes to stdout, folds after 72 chars:
#       $PN -sw 72 file.txt


CP='Copyright (C) 2025, Marc Fege.'
PN="`basename $0`"
EM='13mdf@fege.net'
VS='1.1'
DT='2025-05-20'
CPQRACB='13MDF'
CPQRAHAM='DN9MF'
NET='https://www.fege.net/software'
MB='[none]'

EAn=" ERROR: no arguments allowed with '$1'!"
EA4=' ERROR: too many arguments!  Max: 4.'
EA1=' ERROR: too many arguments!  Max: 1.'
EF=" ERROR: '$1': no such file!"
EO=" ERROR: '$1': unknown option specified!"


FuncHelpShort() {
echo "CALLING: $PN [-bs] [-w width] [file ...]
  -h, --help     Prints out this help.
  -v, --version  Version, date, license.

  -b             Count width in bytes rather than column positions.
  -s             Fold line after the last blank character within margin.
  -w width       Specifies width to use as a line width (default: 80).

DESCRIPTION:
  Folding text using fold(1), but removes trailing spaces.

EXAMPLES:
  1.: Reads from stdin, writes to stdout, folds after 80 chars:
        $PN
  2.: Reads 'file.txt', writes to stdout, folds after 80 chars:
        $PN file.txt
  3.: Reads from stdin, writes to stdout, folds after 72 chars:
        $PN -sw 72
  4.: Reads 'file.txt', writes to stdout, folds after 72 chars:
        $PN -sw 72 file.txt"
}

FuncVersion() {
echo "VERSION, AUTHOR, COPYRIGHT AND CONTACT

Version: $VS, date: $DT.
$CP

  This program is provided by the terms
  of the 'GNU GPL' in version 2.
  The original text of the licence could
  be obtained from:
    http://www.gnu.org/licenses/old~
    -licenses/gpl-2.0

  Internet:
    $NET
  Mailbox (V.34):
    $MB
  Contact:
    E-mail   : $EM
    QRA (CB) : $CPQRACB
    QRA (HAM): $CPQRAHAM"
}

FuncFold() {
	fold $Fb $Fs $Fw $wARG | sed 's/[[:blank:]]*$//'
}


unset Fb
unset Fs
unset Fw
unset wARG
if [ "$#" -gt '4' ] ; then echo "$EA4" >&2 ; FuncHelpShort >&2 ; exit 1
else
	case $1 in
		-h*|--help*|-\?*|\?)
			if [ "$#" -gt '1' ] ; then
				echo "$EAn" >&2 ; FuncHelpShort >&2
				exit 1
			else
				FuncHelpShort ; exit
			fi
			;;
		-v*|--version*)
			if [ "$#" -gt '1' ] ; then
				echo "$EAn" >&2 ; FuncHelpShort >&2
				exit 1
			else
				FuncVersion ; exit
			fi
			;;
		*)
			while getopts bsw: OPT ; do
				case $OPT in
					b)	Fb='-b' ;;
					s)	Fs='-s' ;;
					w)	Fw='-w'
						wARG="$OPTARG" ;;
					*)	FuncHelpShort >&2
						exit 1 ;;
				esac
			done
			shift $((OPTIND - 1))
			;;
	esac
fi
if [ "$#" -gt '1' ] ; then echo "$EA1" >&2 ; FuncHelpShort >&2 ; exit 1
elif [ -r "$1" ] ; then
	FuncFold < "$1"
	else
	case $1 in
		-|'')	FuncFold ;;
		-*|--*)	echo "$EO" >&2 ; FuncHelpShort >&2 ; exit 1 ;;
		*)	echo "$EF" >&2 ; FuncHelpShort >&2 ; exit 1 ;;
	esac
fi
