#!/bin/sh
# Gloria eo in caelo.
#
#
# LICENSE: GNU GPL 2.0.
# bilder.sh(1) Picture renaming tool.
# Copyright (C) 2013-25, Marc Fege alias 13MDF / DN9MF.
# E-Mail: 13mdf@fege.net
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License version 2
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.


SYS="`uname -s`"
CP="Copyright (C) 2013-25, Marc Fege."
EM="13mdf@fege.net"
NM="bilder(1)"
PN="bilder"
VI="0.1"
VS="1.1.9"
DI="2013-06-18"
DT="2025-02-24"
CPQRACB='13MDF'
CPQRAHAM='DN9MF'
NET="https://www.fege.net/software"
PWD=$PWD
OPT=$1
DIR=$2
E1=" FEHLER: kein Zielverzeichnis angegeben!"
E2=" FEHLER: Eingaben identisch!"
E3=" FEHLER: Verzeichnis existiert nicht!"
E4=" FEHLER: kein Leserecht fuer "$PWD
E5=" FEHLER: kein Schreibrecht fuer "$PWD
E6=" FEHLER: kein Ausfuehrungsrecht fuer "$PWD
E7=" FEHLER: kein Leserecht fuer "$DIR
E8=" FEHLER: kein Schreibrecht fuer "$DIR
E9=" FEHLER: kein Ausfuehrungsrecht fuer "$DIR
EO=" FEHLER: '$1': falsche Option angegeben!"
R1=" Bereit."
I1="OPTION eingeben: "

SS="`printf '\37'`"

FuncMenu () {
	read -p "OPTION eingeben: " FN
}


FuncMore () {
	case $OPT in
		-h | --help ) true ;;
		* )
			MC=$(($MC+1))
			if [ $MC -gt "4" ] ; then
				MC=1 
			fi
			read -p "--MORE-- ("$MC"/4)" RE
			;;
	esac
}


FuncSysWarning () {
	if [ $SYS != "NetBSD" -a $SYS != "FreeBSD" -a $SYS != "Linux" ] ; then
		echo "BETRIEBSSYSTEM: "$SYS
		echo "WARNUNG: SYSTEM UNBEKANNT!!!"
		echo "BENUTZUNG AUF EIGENE GEFAHR!"
	fi
}


FuncHelpShort () {
	echo "AUFRUF: $PN OPTION PFAD"
	echo "  Bei Aufruf ohne OPTION startet das"
	echo "  Programm im interaktiven Modus."
	echo "  Im Fehlerfalle startet diese Hilfe."
	echo ""
	echo "OPTIONEN"
	echo "  -h            Zeigt diese Hilfe an."
	echo ""
	echo "       --help   Zeigt die lange Hilfe"
	echo "                fuer den interaktiven"
	echo "                Modus an."
	echo ""
	echo "  -d,  --dir    Ueberfuehrung von Datei-"
	echo "                namen im angegebenen"
	echo "                Arbeitsverzeichnis in"
	echo "                das Standard-Zielformat"
	echo "         %Y-%m-%dT%H%M%z_nnnnn.[:lower:]"
	echo ""
	echo "  -v, --version Version, Datum, Lizenz."
	echo ""
	echo "BEISPIEL"
	echo "  $PN -d /home/user/Bilder"
}


FuncHelpLong () {
	echo $NM"      --HILFE--       "$NM
	echo ""
	echo "NAME"
	echo "     $PN -- Bilderumbenenner"
	echo ""
	echo "BESCHREIBUNG"
	echo "     BILDER ist ein Dateiumbennener,"
	echo "     der Dateinamen zum Katalogisieren"
	echo "     in ein einheitliches Format"
	echo "     ueberfuehrt."
	echo "     Die Bedienung ist selbsterklaerend."
	echo "     Ohne Angabe vom Parametern startet"
	echo "     das Programm im MENUE mit der"
	echo "     Abfrage der auszufuehrenden OPTION."
	echo "     Dort ist das jeweilige Kuerzel der"
	echo "     Funktion einzutippen und"
	echo "     mit [ENTER] abzuschliessen."
	echo "     Nach vollstaendiger Ausfuehrung der"
	echo "     OPTION kehrt das Programm zum MENUE"
	echo "     zurueck, meldet 'Bereit.' und"
	echo "     erwartet eine neue Eingabe."
	echo "     Im Fehlerfalle fragt das Programm"
	echo "     erneut nach einer validen Eingabe."
	FuncMore
	echo "OPTIONEN"
	echo "     h|help    Zeigt diese Hilfe an."
	echo ""
	echo "     p|pwd     Gibt das aktuelle"
	echo "               Arbeitsverzeichnis aus."
	echo ""
	echo "     l|ls      Listet die Dateien im"
	echo "               aktuellen"
	echo "               Arbeitsverzeichnis auf."
	echo ""
	echo "     c|cd      Wechselt das"
	echo "               Arbeitsverzeichnis."
	echo "               Nach Aufforderung ist das"
	echo "               Zielverzeichnis"
	echo "               einzugeben."
	echo ""
	echo "     m|mv      Ueberfuehrung von Datei-"
	echo "               namen im aktuellen"
	echo "               Arbeitsverzeichnis in"
	echo "               das Standard-Zielformat."
	echo ""
	echo "     q|quit    Beendet das Programm."
	echo ""
	FuncMore
	echo "STANDARDKONFORMITAET"
	echo "     Das Programm ist in 'Bourne Shell'"
	echo "     (sh) geschrieben."
	echo "     Die Zeitcodes entsprechen"
	echo "     'ISO 8601'."
	echo ""
	echo "KOMPATIBILITAET"
	echo "     Das Programm ist geschrieben fuer"
	echo "     *BSD + Linux.  Durch diverse UNIX-"
	echo "     Dialekte sind Inkompatibilitaeten"
	echo "     mit dem Zielsystem nicht"
	echo "     ausgeschlossen.  Es wurde versucht,"
	echo "     allein POSIX-kompatible Befehle und"
	echo "     Konstrukte zu verwenden."
	echo ""
	echo "FEHLER"
	echo "     Zwar kein Fehler, aber shell-"
	echo "     bedingt kann das Programm mit ^C"
	echo "     jederzeit terminiert werden."
	echo "     Geschieht dies waehrend einer"
	echo "     Dateioperation, so ist eine"
	echo "     Beschaedigung der gerade abgearbei-"
	echo "     teten Datei theoretisch denkbar."
	FuncMore
	echo "HISTORIE"
	echo "     Ein $NM-Skript in Version $VI"
	echo "     existiert seit $DI."
	echo ""
	echo "AUTOR, URHEBERRECHT UND KONTAKT"
	echo "     "$CP
	echo "     Das Programm steht unter der"
	echo "     'GNU GPL' in Version 2."
	echo "     Der Originaltext der Lizenz ist zu"
	echo "     beziehen unter:"
	echo "       http://www.gnu.org/licenses/old~"
	echo "       -licenses/gpl-2.0"
	echo ""
	echo "     Internet:"
	echo "       $NET"
	echo ""
	echo "     Kontakt:"
	echo "       E-Mail: $EM"
	echo ""
	echo ""
	echo ""
	echo ""
	echo $VS"        "$DT"        "$NM
	FuncMore
}


FuncVersion () {
	echo "VERSION, AUTOR, URHEBERRECHT U. KONTAKT"
	echo ""
	echo "Version: "$VS", Datum: "$DT.
	echo $CP
	echo ""
	echo "     Das Programm steht unter der"
	echo "     'GNU GPL' in Version 2."
	echo "     Der Originaltext der Lizenz ist zu"
	echo "     beziehen unter:"
	echo "       http://www.gnu.org/licenses/old~"
	echo "       -licenses/gpl-2.0"
	echo ""
	echo "     Internet:"
	echo "       $NET"
	echo ""
	echo "     Kontakt:"
	echo "       E-Mail   : $EM"
	echo "       QRA (CB) : $CPQRACB"
	echo "       QRA (HAM): $CPQRAHAM"
	echo ""
}


FuncHeadStart () {
	echo "----------[ BILDERUMBENENNER ]----------"
	echo ""
	echo $CP
	echo "Version: "$VS", Datum: "$DT.
	echo ""
	echo "Dateinamen vereinheitlichen:"
	echo " 1.: OPTION 'c', 2.: OPTION 'm' waehlen."
	echo ""
}


FuncHeadRun () {
	echo "   +--[ OPTIONEN: ]-----------------+"
	echo "   |                                |"
	echo "   | HILFE/INFO           :  h|help |"
	echo "   | ARB.VERZ. ANZEIGEN   :  p|pwd  |"
	echo "   | VERZEICHNISINH. ANZ. :  l|ls   |"
	echo "   | WECHSEL DES ARB.VERZ.:  c|cd   |"
	echo "   | UMBENENNEN IN STD.ZF.:  m|mv   |"
	echo "   | PROGRAMMENDE         :  q|quit |"
	echo "   +--------------------------------+"
	echo ""
	echo "   +--[ STANDARD-ZIELFORMAT: ]------+"
	echo "   |                                |"
	echo "   | %Y-%m-%dT%H%M%z_nnnnn.[:lower:]|"
	echo "   +--------------------------------+"
	echo ""
}


FuncTail () {
	echo "========================================"
	echo ""
	echo ""
	echo ""
	echo ""
	echo ""
	echo ""
}


FuncCd () {
	PWD=""
	while [ -z "$PWD" -o ! -d "$PWD" -o ! -r "$PWD" -o ! -w "$PWD" -o ! -x "$PWD" ]
		do read -p "ZIELVERZEICHNIS eingeben: " PWD
	done
	cd "$PWD"
}


FuncBsdFilename () {
	echo $FILENAME | sed "s/$SS/ /g" | stat -f %Sm -t %Y-%m-%dT%H%M%z
}


FuncSysvFilename () {
	echo "$FILENAME" | sed "s/$SS/ /g" | xargs stat -c %y | cut -c 1-13,15-16,31-35 | tr ' ' 'T'
}


FuncFillzeros () {
	if [ $NUMBER -le "9" ] ; then
		ADDNUMBER="0000"
	elif [ $NUMBER -ge "10" -a $NUMBER -le "99" ] ; then
		ADDNUMBER="000"
	elif [ $NUMBER -ge "100" -a $NUMBER -le "999" ] ; then
		ADDNUMBER="00"
	elif [ $NUMBER -ge "1000" -a $NUMBER -le "9999" ] ; then
		ADDNUMBER="0"
	else ADDNUMBER=""
	fi
	echo $ADDNUMBER
}


FuncFilenameextension () {
	echo $FILENAME | cut -f $(($(echo $FILENAME | tr -cd . | wc -m)+1))- -d . | tr "[:upper:]" "[:lower:]"
}


FuncBsdRename () {
	NUMBER=$((1))
	for FILENAME in $(ls -1tr | grep -v $0 | sed "s/ /$SS/g") ; do
		mv "$(echo $FILENAME | sed "s/$SS/ /g")" $(FuncBsdFilename)_$(FuncFillzeros)$NUMBER.$(FuncFilenameextension)
		NUMBER=$((NUMBER+1))
	done
}


FuncSysvRename () {
	NUMBER=$((1))
	for FILENAME in $(ls -1tr | grep -v $0 | sed "s/ /$SS/g") ; do
		mv "$(echo $FILENAME | sed "s/$SS/ /g")" $(FuncSysvFilename)_$(FuncFillzeros)$NUMBER.$(FuncFilenameextension)
		NUMBER=$((NUMBER+1))
	done
}


FuncRename () {
	if [ -n "$PWD" ] ; then
		if [ -d "$PWD" ] ; then
			if [ -r "$PWD" ] ; then
				if [ -w "$PWD" ] ; then
					if [ -x "$PWD" ] ; then
						if [ $SYS = "NetBSD" -o $SYS = "FreeBSD" ] ; then
								FuncBsdRename
							elif [ $SYS = "Linux" ] ; then
								FuncSysvRename
							else FuncSysvRename
						fi
						else echo $E6 >&2
					fi
					else echo $E5 >&2
				fi
				else echo $E4 >&2
			fi
			else echo $E3 >&2
		fi
		else echo $E1 >&2
	fi
}


FuncRenameNoninteractive () {
	if [ -n "$DIR" ] ; then
		if [ -d "$DIR" ] ; then
			if [ -r "$DIR" ] ; then
				if [ -w "$DIR" ] ; then
					if [ -x "$DIR" ] ; then
						cd "$DIR"
						else echo $E9 >&2 ; exit 1
					fi
					else echo $E8 >&2 ; exit 1
				fi
				else echo $E7 >&2 ; exit 1
			fi
			else echo $E3 >&2 ; exit 1
		fi
		else echo $E1 >&2 ; exit 1
	fi

	if [ -n "$PWD" ] ; then
		if [ -d "$PWD" ] ; then
			if [ -r "$PWD" ] ; then
				if [ -w "$PWD" ] ; then
					if [ -x "$PWD" ] ; then
						if [ $SYS = "NetBSD" -o $SYS = "FreeBSD" ] ; then
								FuncBsdRename
							elif [ $SYS = "Linux" ] ; then
								FuncSysvRename
							else FuncSysvRename
						fi
						exit 0
						else echo $E6 >&2 ; exit 1
					fi
					else echo $E5 >&2 ; exit 1
				fi
				else echo $E4 >&2 ; exit 1
			fi
			else echo $E3 >&2 ; exit 1
		fi
		else echo $E1 >&2 ; exit 1
	fi
	cd -
}


case $OPT in
	-h)	FuncHelpShort ;;
	--help)	FuncHelpLong ;;
	-d|--dir)
		FuncSysWarning
		FuncRenameNoninteractive
		;;
	-v|--version)
		FuncVersion ; exit 1 ;;
	"")
		FuncHeadStart
		FuncHeadRun
		while : ; do
			FuncMenu
			case $FN in
				h|H|help|Help|HELP)
					FuncHelpLong
					echo $R1 ;; 
				p|P|pwd|Pwd|PWD)
					pwd ;;
				l|L|ls|Ls|LS|d|D|dir|Dir|DIR)
					ls -l ;;
				c|C|cd|Cd|CD|chdir|Chdir|CHDIR)
					FuncCd ;;
				m|M|mv|Mv|MV|move|Move|MOVE|r|R|ren|Ren|REN|rename|Rename|RENAME)
					FuncSysWarning
					FuncRename
					echo $R1
					;;
				e|E|q|Q|exit|Exit|EXIT|quit|Quit|QUIT)
					exit 0 ;;
				^D)
					exit 0 ;;
				*)
					FuncHelpLong
					echo $R1 ;; 
			esac
			FuncTail && FuncHeadRun
		done
		;;
	*)	echo "$EO" >&2 ; FuncHelpShort >&2 ; exit 1 ;;
esac
exit 0
