#!/bin/sh
# Gloria eo in caelo.
#
#
# LICENSE: GNU GPL 2.0.
# srl.ksh(1) Serial line speed emulation for sh(1).
# Copyright (C) 2024-25, Marc Fege alias 13MDF / DN9MF.
# E-Mail: 13mdf@fege.net
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License version 2
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
#
# DESCRIPTION:
# Reads DATA given either in $1 or from stdin, stores it into a variable and
# prints it's values out again.
# Comparable to cat(1).
#
#
# EXAMPLES:
# 1.:	./srl.sh		# Reads from stdin and prints out.
# 2.:	./srl.sh 300		# Reads from stdin and prints out with 300 Bd.
# 3.:	./srl.sh file.txt	# Reads "file.txt" and prints out.
# 4.:	./srl.sh file.txt 300	# Reads "file.txt" and prints out with 300 Bd.


if [ -z "$2" ]
	then
		if [ -r "$1" ]
			then	DATA="$(cat $1)"
			else
				if [ "$1" -le 0 ]
					then	unset Bd
					else	Bd="$(echo "8/$1" | bc -l)"
				fi
				DATA="$(cat)"
		fi
	else
		if [ "$2" -le 0 ]
			then	unset Bd
			else	Bd="$(echo "8/$2" | bc -l)"
		fi
		DATA="$(cat $1)"
fi

AS="$(printf '\37')"
QS="$(printf '\36')"
IFS="$(printf '\34')"
if [ "$Bd" ]
	then
		for char in $(echo "$DATA" | sed -e "s/*/$AS/g" -e "s/?/$QS/g" -e "s/./&$IFS/g" -e "s/^/$IFS&/g") ; do
			sleep "$Bd"
			case "$char" in
				"$AS")	echo -n '*' ;;
				"$QS")	echo -n '?' ;;
				*)	echo -n "$char" ;;
			esac
		done
		echo
	else	echo "$DATA"
fi
