#!/bin/ksh
# Gloria eo in caelo.
#
#
# LICENSE: GNU GPL 2.0.
# srl.ksh(1) Serial line speed emulation for ksh(1) or bash(1).
# Copyright (C) 2024-25, Marc Fege alias 13MDF / DN9MF.
# E-Mail: 13mdf@fege.net
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License version 2
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
#
# DESCRIPTION:
# Reads DATA given either in $1 or from stdin, stores it line by line into an
# array and prints it's values out again, thus every character of each line.
# Comparable to cat(1).
#
#
# EXAMPLES:
# 1.:	./srl.ksh		# Reads from stdin and prints out.
# 2.:	./srl.ksh 300		# Reads from stdin and prints out with 300 Bd.
# 3.:	./srl.ksh file.txt	# Reads "file.txt" and prints out.
# 4.:	./srl.ksh file.txt 300	# Reads "file.txt" and prints out with 300 Bd.


if [ -z "$2" ]
	then
		if [ -r "$1" ]
			then	while IFS= read -r DATA[$((i+=1))] ; do : ; done < "$1"
			else
				if [ "$1" -le 0 ]
					then	unset Bd
					else	Bd="$(echo "8/$1" | bc -l)"
				fi
				while IFS= read -r DATA[$((i+=1))] ; do : ; done
		fi
	else
		if [ "$2" -le 0 ]
			then	unset Bd
			else	Bd="$(echo "$2/8" | bc -l)"
		fi
		while IFS= read -r DATA[$((i+=1))] ; do : ; done < "$1"
fi
unset DATA[i]

AS="$(printf '\37')"
QS="$(printf '\36')"
IFS="$(printf '\34')"
if [ "$Bd" ]
	then
		for line in "${DATA[@]}" ; do
			for char in $(echo "$line" | sed -e "s/*/$AS/g" -e "s/?/$QS/g" -e "s/./&$IFS/g" -e "s/$IFS$//g") ; do
				sleep "$Bd"
				case "$char" in
					"$AS")	echo -n '*' ;;
					"$QS")	echo -n '?' ;;
					*)	echo -n "$char" ;;
				esac
			done
			echo
		done
	else	printf '%s\n' "${DATA[@]}"
fi
