#!/bin/sh
# Gloria eo in caelo.
#
#
# LICENSE: GNU GPL 2.0.
# roffpdf(1) groff(1) compiling script for PDF output.
# Copyright (C) 2023-25, Marc Fege alias 13MDF / DN9MF.
# E-Mail: 13mdf@fege.net
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License version 2
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor,
# Boston, MA 02110-1301, USA.
#
#
# EXAMPLES:
# ./roffpdf.sh book.me
# ./roffpdf.sh book.me bibl.ref


CP='Copyright (C) 2023-25, Marc Fege.'
PN="`basename $0`"
EM='13mdf@fege.net'
VS='1.6'
DT='2025-04-16'
CPQRACB='13MDF'
CPQRAHAM='DN9MF'
NET='https://www.fege.net/software'
MB='[none]'

EA=' ERROR: too many arguments!  Max: 2.'
EF1=' ERROR: $1: no document file stated!'
EF2=" ERROR: '$1': no such file or file not readable!"
EO=" ERROR: '$1': unknown option specified!"


FuncHelpShort() {
echo "CALLING: $PN [DocumentFile] [ReferenceFile]
  -h, --help     Prints out this help.
  -v, --version  Version, date, license.

DESCRIPTION:
  groff(1) compiling script for PostScript output.
  It determines used macro set according to file ending automatically.

EXAMPLES:
  1.: Reads 'book.me' and writes to stdout:
        $PN book.me
  2.: Reads 'book.me' and the refer(1) file 'bibl.ref' and writes to
      stdout:
        $PN book.me bibl.ref"
}

FuncVersion() {
echo "VERSION, AUTHOR, COPYRIGHT AND CONTACT

Version: $VS, date: $DT.
$CP

  This program is provided by the terms
  of the 'GNU GPL' in version 2.
  The original text of the licence could
  be obtained from:
    http://www.gnu.org/licenses/old~
    -licenses/gpl-2.0

  Internet:
    $NET
  Mailbox (V.34):
    $MB
  Contact:
    E-mail   : $EM
    QRA (CB) : $CPQRACB
    QRA (HAM): $CPQRAHAM"
}


if [ "$#" -gt 2 ] ; then echo "$EA" >&2 ; FuncHelpShort >&2 ; exit 1
else
	case $1 in
		-h*|--help*)	FuncHelpShort ;;
		-v*|--version*)	FuncVersion ;;
		-|'')	echo "$EF1" >&2 ; FuncHelpShort >&2 ; exit 1 ;;
		-*|--*)	echo "$EO" >&2 ; FuncHelpShort >&2 ; exit 1 ;;
		*)
OUTPUT="`echo $1 | sed 's/\.[^.]*$//'`"
M="-`echo $1 | sed 's/.*[.]\(.*\)/\1/' | tr '[:upper:]' '[:lower:]'`"
SOELIM="`which soelim`"
SOELIM="`echo $?`"
if [ "$SOELIM" -eq '0' ]
	then	SOELIM='soelim'
	else	SOELIM='cat'
		echo " CAUTION: 'soelim' is missing!" \
			' Other source files could not be included!' >&2
fi
PRECONV="`which preconv`"
PRECONV="`echo $?`"
if [ "$PRECONV" -eq '0' ]
	then	PRECONV='preconv'
	else	PRECONV='cat'
		echo " CAUTION: 'preconv' is missing!" \
			' Translation of non-ASCII chars omitted!' >&2
fi
CHEM="`which chem`"
CHEM="`echo $?`"
if [ "$CHEM" -eq '0' ]
	then	CHEM='chem'
	else	CHEM='cat'
		echo " CAUTION: 'chem' is missing!" \
			' No chemicals could be rendered!' >&2
fi
GRAP="`which grap`"
GRAP="`echo $?`"
if [ "$GRAP" -eq '0' ]
	then	GRAP='grap'
	else	GRAP='cat'
		echo " CAUTION: 'grap' is missing!" \
			' No graphs could be rendered!' >&2
fi
GRN="`which grn`"
GRN="`echo $?`"
if [ "$GRN" -eq '0' ]
	then	GRN='grn'
	else	GRN='cat'
		echo " CAUTION: 'grn' is missing!" \
			' No gremlin pictures could be rendered!' >&2
fi
IDEAL="`which ideal`"
IDEAL="`echo $?`"
if [ "$IDEAL" -eq '0' ]
	then	IDEAL='ideal'
	else	IDEAL='cat'
		echo " CAUTION: 'ideal' is missing!" \
			' No ideal pictures could be rendered!' >&2
fi
GROFFVER="`groff -v | head -1 | cut -f 4 -d ' ' | tr -d '.'`"
if [ "$2" -a "$2" != '-' ] ; then
	p="-p $2"
fi
		if [ ! -r "$1" ] ; then
			echo "$EF2" >&2 ; FuncHelpShort >&2 ; exit 1
		else
if [ "$GROFFVER" -gt '1192' ] ; then
	m='-mpdfmark -mden'
	T='-Tpdf'
	if [ "$M" = '-ms' ] ; then
		M='-mspdf'
	fi
	$SOELIM "$1" | sed '/^\.\\\"/d' | $PRECONV | refer $p \
		| $CHEM | $GRAP | $GRN | $IDEAL | tbl | eqn $T | pic \
		| groff -U $T -dpaper=a4 -P-pa4 -P-e $M $m \
		#> "$OUTPUT".pdf
else
	$SOELIM "$1" | sed '/^\.\\\"/d' | ./depdfmark.sh | $PRECONV \
		| refer $p | $CHEM | $GRAP | $GRN | $IDEAL | tbl | eqn \
		| pic | groff -dpaper=a4 -P-pa4 $M $m | ps2pdf -
fi
		fi
		;;
	esac
fi
