#!/bin/sh
# Gloria eo in caelo.
#
#
# LICENSE: GNU GPL 2.0.
# roff2utf8(1) - conversion script from groff_char(7) to UTF-8 chars.
# Copyright (C) 2025, Marc Fege alias 13MDF.
# E-Mail: 13mdf@fege.net
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License version 2
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor,
# Boston, MA 02110-1301, USA.
#
#
# EXAMPLES:
# 1.: ./roff2utf8.sh           # Reads from stdin, writes to stdout.
# 2.: ./roff2utf8.sh book.me   # Reads 'book.me', writes to stdout.
# 3.: Reads 'book.me', writes to 'book2.me':
#     ./roff2utf8.sh book.me book2.me
# 4.: Reads from stdin, writes to 'book2.me':
#     ./roff2utf8.sh - book2.me
# 5.: Reads & writes 'book.me' & converts groff_char(7) inplace:
#     ./roff2utf8.sh -i book.me


CP='Copyright (C) 2025, Marc Fege.'
PN="`basename $0`"
EM='13mdf@fege.net'
VS='1.3'
DT='2025-10-28'
CPQRACB='13MDF'
CPQRAHAM='DN9MF'
NET='https://www.fege.net/software'
MB='[none]'

EAn=" ERROR: no arguments allowed with '$1'!"
EA1=' ERROR: too many arguments!  Max allowed with "-i": 1.'
EA2=' ERROR: too many arguments!  Max: 2.'
EA3=' ERROR: too many arguments!  Max: 3.'
EFI=" ERROR: '$2': no such file!"
EF=" ERROR: '$1': no such file!"
EI=" ERROR: '$1': files in "'$1 and $2 identical!'
EO=" ERROR: '$1': unknown option specified!"


FuncHelpShort() {
echo "CALLING: $PN [-i] [FileIn] [FileOut]
  -h|--help       Prints out this help.
  -v|--version    Version, date, license.

  -i [FileIn]     Converts groff_char(7) to UTF-8 chars inplace.

DESCRIPTION:
   Conversion script from groff_char(7) to UTF-8 characters.

EXAMPLES:
  1.: Reads from stdin, writes to stdout:
        $PN
  2.: Reads 'book.me', writes to stdout:
        $PN book.me
  3.: Reads 'book.me', writes to 'book2.me':
        $PN book.me book2.me
  4.: Reads from stdin, writes to 'book2.me':
        $PN - book2.me
  5.: Reads & writes 'book.me' & converts groff_char(7) inplace:
        $PN -i book.me"
}

FuncVersion() {
echo "VERSION, AUTHOR, COPYRIGHT AND CONTACT

Version: $VS, date: $DT.
$CP

  This program is provided by the terms
  of the 'GNU GPL' in version 2.
  The original text of the licence could
  be obtained from:
    http://www.gnu.org/licenses/old~
    -licenses/gpl-2.0

  Internet:
    $NET
  Mailbox (V.34):
    $MB
  Contact:
    E-mail   : $EM
    QRA (CB) : $CPQRACB
    QRA (HAM): $CPQRAHAM"
}

FuncR2UTF8() {
	sed $FI	-e "s/\\\(\`A/`printf '\303\200'`/g" \
		-e "s/\\\(\`a/`printf '\303\240'`/g" \
		-e "s/\\\('A/`printf '\303\201'`/g" \
		-e "s/\\\('a/`printf '\303\241'`/g" \
		-e "s/\\\(\^A/`printf '\303\202'`/g" \
		-e "s/\\\(\^a/`printf '\303\242'`/g" \
		-e "s/\\\(~A/`printf '\303\203'`/g" \
		-e "s/\\\(~a/`printf '\303\243'`/g" \
		-e "s/\\\(:A/`printf '\303\204'`/g" \
		-e "s/\\\(:a/`printf '\303\244'`/g" \
		-e "s/\\\(oA/`printf '\303\205'`/g" \
		-e "s/\\\(oa/`printf '\303\245'`/g" \
		-e "s/\\\(AE/`printf '\303\206'`/g" \
		-e "s/\\\(ae/`printf '\303\246'`/g" \
		-e "s/\\\(\`E/`printf '\303\210'`/g" \
		-e "s/\\\(\`e/`printf '\303\250'`/g" \
		-e "s/\\\('E/`printf '\303\211'`/g" \
		-e "s/\\\('e/`printf '\303\251'`/g" \
		-e "s/\\\(\^E/`printf '\303\212'`/g" \
		-e "s/\\\(\^e/`printf '\303\252'`/g" \
		-e "s/\\\(:E/`printf '\303\213'`/g" \
		-e "s/\\\(:e/`printf '\303\253'`/g" \
		-e "s/\\\(\`I/`printf '\303\214'`/g" \
		-e "s/\\\(\`i/`printf '\303\254'`/g" \
		-e "s/\\\('I/`printf '\303\215'`/g" \
		-e "s/\\\('i/`printf '\303\255'`/g" \
		-e "s/\\\(\^I/`printf '\303\216'`/g" \
		-e "s/\\\(\^i/`printf '\303\256'`/g" \
		-e "s/\\\(:I/`printf '\303\217'`/g" \
		-e "s/\\\(:i/`printf '\303\257'`/g" \
		-e "s/\\\(\`O/`printf '\303\222'`/g" \
		-e "s/\\\(\`o/`printf '\303\262'`/g" \
		-e "s/\\\('O/`printf '\303\223'`/g" \
		-e "s/\\\('o/`printf '\303\263'`/g" \
		-e "s/\\\(\^O/`printf '\303\224'`/g" \
		-e "s/\\\(\^o/`printf '\303\264'`/g" \
		-e "s/\\\(~O/`printf '\303\225'`/g" \
		-e "s/\\\(~o/`printf '\303\265'`/g" \
		-e "s/\\\(:O/`printf '\303\226'`/g" \
		-e "s/\\\(:o/`printf '\303\266'`/g" \
		-e "s/\\\(\/O/`printf '\303\230'`/g" \
		-e "s/\\\(\/o/`printf '\303\270'`/g" \
		-e "s/\\\(OE/`printf '\305\222'`/g" \
		-e "s/\\\(oe/`printf '\303\223'`/g" \
		-e "s/\\\(\`U/`printf '\303\231'`/g" \
		-e "s/\\\(\`u/`printf '\303\271'`/g" \
		-e "s/\\\('U/`printf '\303\232'`/g" \
		-e "s/\\\('u/`printf '\303\272'`/g" \
		-e "s/\\\(\^U/`printf '\303\233'`/g" \
		-e "s/\\\(\^u/`printf '\303\273'`/g" \
		-e "s/\\\(:U/`printf '\303\234'`/g" \
		-e "s/\\\(:u/`printf '\303\274'`/g" \
		-e "s/\\\(\.i/`printf '\304\261'`/g" \
		-e "s/\\\(\.j/`printf '\310\267'`/g" \
		-e "s/\\\(\/L/`printf '\305\201'`/g" \
		-e "s/\\\(\/l/`printf '\305\202'`/g" \
		-e "s/\\\(,C/`printf '\303\207'`/g" \
		-e "s/\\\(,c/`printf '\303\247'`/g" \
		-e "s/\\\(~N/`printf '\303\221'`/g" \
		-e "s/\\\(~n/`printf '\303\261'`/g" \
		-e "s/\\\(-D/`printf '\303\220'`/g" \
		-e "s/\\\(Sd/`printf '\303\260'`/g" \
		-e "s/\\\('Y/`printf '\303\235'`/g" \
		-e "s/\\\('y/`printf '\303\275'`/g" \
		-e "s/\\\(:Y/`printf '\305\270'`/g" \
		-e "s/\\\(:y/`printf '\303\277'`/g" \
		-e "s/\\\(TP/`printf '\303\236'`/g" \
		-e "s/\\\(Tp/`printf '\303\276'`/g" \
		-e "s/\\\('C/`printf '\304\206'`/g" \
		-e "s/\\\('c/`printf '\304\207'`/g" \
		-e "s/\\\(S1/`printf '\302\271'`/g" \
		-e "s/\\\(S2/`printf '\302\262'`/g" \
		-e "s/\\\(S3/`printf '\302\263'`/g" \
		-e "s/\\\(\*\*/`printf '\342\210\227'`/g" \
		-e "s/\\\(es/`printf '\342\210\205'`/g" \
		-e "s/\\\(ss/`printf '\303\237'`/g" \
		-e "s/\\\(ss/`printf '\341\272\236'`/g" \
		-e "s/\\\(vS/`printf '\305\240'`/g" \
		-e "s/\\\(vs/`printf '\305\241'`/g" \
		-e "s/\\\(vZ/`printf '\305\275'`/g" \
		-e "s/\\\(vz/`printf '\305\246'`/g" \
		-e "s/\\\(br/`printf '\342\224\202'`/g" \
		-e "s/\\\(rn/`printf '\342\200\276'`/g" \
		-e "s/\\\(ct/`printf '\302\242'`/g" \
		-e "s/\\\(eu/`printf '\342\202\254'`/g" \
		-e "s/\\\(Eu/`printf '\342\202\254'`/g" \
		-e "s/\\\(Ye/`printf '\302\245'`/g" \
		-e "s/\\\(Po/`printf '\302\243'`/g" \
		-e "s/\\\(Cs/`printf '\302\244'`/g" \
		-e "s/\\\(%0/`printf '\342\200\260'`/g" \
		-e "s/\\\(fm/`printf '\342\200\262'`/g" \
		-e "s/\\\(sd/`printf '\342\200\263'`/g" \
		-e "s/\\\(mc/`printf '\302\265'`/g" \
		-e "s/\\\(Of/`printf '\302\252'`/g" \
		-e "s/\\\(Om/`printf '\302\272'`/g" \
		-e "s/\\\(em/`printf '\342\200\224'`/g" \
		-e "s/\\\(en/`printf '\342\200\223'`/g" \
		-e "s/\\\(co/`printf '\302\251'`/g" \
		-e "s/\\\(rg/`printf '\302\256'`/g" \
		-e "s/\\\(tm/`printf '\342\204\242'`/g" \
		-e "s/\\\(sc/`printf '\302\247'`/g" \
		-e "s/\\\(r!/`printf '\302\241'`/g" \
		-e "s/\\\(r?/`printf '\302\277'`/g" \
		-e "s/\\\(de/`printf '\302\260'`/g" \
		-e "s/\\\(lq/`printf '\342\200\234'`/g" \
		-e "s/\\\(rq/`printf '\342\200\235'`/g" \
		-e "s/\\\(Bq/`printf '\342\200\236'`/g" \
		-e "s/\\\(bq/`printf '\342\200\232'`/g" \
		-e "s/\\\(oq/`printf '\342\200\230'`/g" \
		-e "s/\\\(cq/`printf '\342\200\231'`/g" \
		-e "s/\\\(aq/\'/g" \
		-e 's/\\(dq/\"/g' \
		-e "s/\\\(Fo/`printf '\302\253'`/g" \
		-e "s/\\\(Fc/`printf '\302\273'`/g" \
		-e "s/\\\(fo/`printf '\342\200\271'`/g" \
		-e "s/\\\(fc/`printf '\342\200\272'`/g" \
		-e "s/\\\(<-/`printf '\342\206\220'`/g" \
		-e "s/\\\(ua/`printf '\342\206\221'`/g" \
		-e "s/\\\(->/`printf '\342\206\222'`/g" \
		-e "s/\\\(da/`printf '\342\206\223'`/g" \
		-e "s/\\\(<>/`printf '\342\206\224'`/g" \
		-e "s/\\\(va/`printf '\342\206\225'`/g" \
		-e "s/\\\(lA/`printf '\342\207\220'`/g" \
		-e "s/\\\(uA/`printf '\342\207\221'`/g" \
		-e "s/\\\(rA/`printf '\342\207\222'`/g" \
		-e "s/\\\(dA/`printf '\342\207\223'`/g" \
		-e "s/\\\(hA/`printf '\342\207\224'`/g" \
		-e "s/\\\(vA/`printf '\342\207\225'`/g" \
		-e "s/\\\(an/`printf '\342\216\257'`/g" \
		-e "s/\\\(ci/`printf '\342\227\213'`/g" \
		-e "s/\\\(ci/`printf '\342\227\213'`/g" \
		-e "s/\\\(bu/`printf '\342\200\242'`/g" \
		-e "s/\\\(dg/`printf '\342\200\240'`/g" \
		-e "s/\\\(dd/`printf '\342\200\241'`/g" \
		-e "s/\\\(lz/`printf '\342\227\212'`/g" \
		-e "s/\\\(sq/`printf '\342\226\241'`/g" \
		-e "s/\\\(ps/`printf '\302\266'`/g" \
		-e "s/\\\(pc/`printf '\302\267'`/g" \
		-e "s/\\\(if/`printf '\342\210\236'`/g" \
		-e "s/\\\(Ah/`printf '\342\204\265'`/g" \
		-e "s/\\\(Re/`printf '\342\204\234'`/g" \
		-e "s/\\\(Fn/`printf '\306\222'`/g" \
		-e "s/\\\(\*A/`printf '\316\221'`/g" \
		-e "s/\\\(\*B/`printf '\316\222'`/g" \
		-e "s/\\\(\*G/`printf '\316\223'`/g" \
		-e "s/\\\(\*D/`printf '\316\224'`/g" \
		-e "s/\\\(\*E/`printf '\316\225'`/g" \
		-e "s/\\\(\*Z/`printf '\316\226'`/g" \
		-e "s/\\\(\*Y/`printf '\316\227'`/g" \
		-e "s/\\\(\*H/`printf '\316\230'`/g" \
		-e "s/\\\(\*I/`printf '\316\231'`/g" \
		-e "s/\\\(\*K/`printf '\316\232'`/g" \
		-e "s/\\\(\*L/`printf '\316\233'`/g" \
		-e "s/\\\(\*M/`printf '\316\234'`/g" \
		-e "s/\\\(\*N/`printf '\316\235'`/g" \
		-e "s/\\\(\*C/`printf '\316\236'`/g" \
		-e "s/\\\(\*O/`printf '\316\237'`/g" \
		-e "s/\\\(\*P/`printf '\316\240'`/g" \
		-e "s/\\\(\*R/`printf '\316\241'`/g" \
		-e "s/\\\(\*S/`printf '\316\243'`/g" \
		-e "s/\\\(\*T/`printf '\316\244'`/g" \
		-e "s/\\\(\*U/`printf '\316\245'`/g" \
		-e "s/\\\(\*F/`printf '\316\246'`/g" \
		-e "s/\\\(\*X/`printf '\316\247'`/g" \
		-e "s/\\\(\*Q/`printf '\316\250'`/g" \
		-e "s/\\\(\*W/`printf '\316\251'`/g" \
		-e "s/\\\(\*a/`printf '\316\261'`/g" \
		-e "s/\\\(\*b/`printf '\316\262'`/g" \
		-e "s/\\\(\*g/`printf '\316\263'`/g" \
		-e "s/\\\(\*d/`printf '\316\264'`/g" \
		-e "s/\\\(\*e/`printf '\316\265'`/g" \
		-e "s/\\\(\*z/`printf '\316\266'`/g" \
		-e "s/\\\(\*y/`printf '\316\267'`/g" \
		-e "s/\\\(\*h/`printf '\316\270'`/g" \
		-e "s/\\\(\*i/`printf '\316\271'`/g" \
		-e "s/\\\(\*k/`printf '\316\272'`/g" \
		-e "s/\\\(\*l/`printf '\316\273'`/g" \
		-e "s/\\\(\*m/`printf '\316\274'`/g" \
		-e "s/\\\(\*n/`printf '\316\275'`/g" \
		-e "s/\\\(\*c/`printf '\316\276'`/g" \
		-e "s/\\\(\*o/`printf '\316\277'`/g" \
		-e "s/\\\(\*p/`printf '\317\200'`/g" \
		-e "s/\\\(\*r/`printf '\317\201'`/g" \
		-e "s/\\\(\*s/`printf '\317\203'`/g" \
		-e "s/\\\(\*t/`printf '\317\204'`/g" \
		-e "s/\\\(\*u/`printf '\317\205'`/g" \
		-e "s/\\\(\*f/`printf '\317\225'`/g" \
		-e "s/\\\(\*x/`printf '\317\207'`/g" \
		-e "s/\\\(\*q/`printf '\317\210'`/g" \
		-e "s/\\\(\*w/`printf '\317\211'`/g" \
		-e "s/\\\(+e/`printf '\317\265'`/g" \
		-e "s/\\\(+h/`printf '\317\221'`/g" \
		-e "s/\\\(+p/`printf '\317\226'`/g" \
		-e "s/\\\(+f/`printf '\317\206'`/g" \
		-e "s/\\\(SP/`printf '\342\231\240'`/g" \
		-e "s/\\\(CL/`printf '\342\231\243'`/g" \
		-e "s/\\\(HE/`printf '\342\231\245'`/g" \
		-e "s/\\\(DI/`printf '\342\231\246'`/g" \
		-e "s/\.\.\./`printf '\342\200\246'`/g" \
		-e "s/\\\~/`printf '\302\240'`/g"
}


if [ "$#" -gt '3' ] ; then echo "$EA3" >&2 ; FuncHelpShort >&2 ; exit 1
else
	case $1 in
		-h*|--help*|-\?*|\?)
			if [ "$#" -gt '1' ] ; then
				echo "$EAn" >&2 ; FuncHelpShort >&2
				exit 1
			else
				FuncHelpShort ; exit
			fi
			;;
		-v*|--version*)
			if [ "$#" -gt '1' ] ; then
				echo "$EAn" >&2 ; FuncHelpShort >&2
				exit 1
			else
				FuncVersion ; exit
			fi
			;;
		*)
			while getopts iu OPT ; do
				case $OPT in
					i)
					if [ "$#" -gt '2' ] ; then
						echo "$EA1" >&2
						FuncHelpShort >&2
						exit 1
					elif [ ! -r "$2" ] ; then
						echo "$EFI" >&2
						FuncHelpShort >&2
						exit 1
					else
						FI="-i $2"
					fi
					;;
					*)	FuncHelpShort >&2
						exit 1 ;;
				esac
			done
			shift $((OPTIND - 1))
			;;
	esac
fi
if [ "$#" -gt '2' ] ; then echo "$EA2" >&2 ; FuncHelpShort >&2 ; exit 1
elif [ -r "$1" -a "$2" ] ; then
	case $2 in
		-|'')	FuncR2UTF8 < "$1" ;;
		*)
			if [ "$1" != "$2" ] ; then
					FuncR2UTF8 > "$2"
				else
					echo "$EI" >&2
					FuncHelpShort >&2
					exit 1
			fi
			;;
	esac
elif [ -r "$1" ] ; then
	FuncR2UTF8 < "$1"
	else
	case $1 in
		-|'')
		case $2 in
			-|'')	FuncR2UTF8 ;;
			*)	FuncR2UTF8 > "$2" ;;
		esac
		;;
		-*|--*)	echo "$EO" >&2 ; FuncHelpShort >&2 ; exit 1 ;;
		*)	echo "$EF" >&2 ; FuncHelpShort >&2 ; exit 1 ;;
	esac
fi
