#!/bin/sh
# Gloria eo in caelo.
#
#
# LICENSE: GNU GPL 2.0.
# depdfmark(1) - *roff preprocessor to remove 'pdfmark' macro constructs
# from nroff/troff.
# Copyright (C) 2025, Marc Fege alias 13MDF.
# E-Mail: 13mdf@fege.net
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License version 2
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor,
# Boston, MA 02110-1301, USA.
#
#
# EXAMPLES:
# 1.: ./depdfmark.sh		# Reads from stdin, writes to stdout.
# 2.: ./depdfmark.sh book.me 	# Reads 'book.me', writes to stdout.
# 3.: Reads 'book.me', writes to 'book2.me':
#     ./depdfmark.sh book.me book2.me
# 4.: Reads from stdin, writes to 'book2.me':
#     ./depdfmark.sh - book2.me


CP='Copyright (C) 2025, Marc Fege.'
PN="`basename $0`"
EM='13mdf@fege.net'
VS='1.1'
DT='2025-02-24'
CPQRACB='13MDF'
CPQRAHAM='DN9MF'
NET='https://www.fege.net/software'
MB='[none]'

EA=' ERROR: too many arguments!  Max: 2.'
EF=" ERROR: '$1': no such file!"
EI=" ERROR: '$1': files in "'$1 and $2 identical!'
EO=" ERROR: '$1': unknown option specified!"


FuncHelpShort() {
echo "CALLING: $PN [FileIn] [FileOut]
  -h, --help     Prints out this help.
  -v, --version  Version, date, license.

DESCRIPTION:
  *roff preprocessor to remove 'pdfmark' macro constructs.

EXAMPLES:
  1.: Reads from stdin, writes to stdout:
        $PN
  2.: Reads 'bibl.bib', writes to stdout:
        $PN book.me
  3.: Reads 'book.me', writes to 'book2.me':
       $PN book.me book2.me
  4.: Reads from stdin, writes to 'book2.me':
        $PN - book2.me"
}

FuncVersion() {
echo "VERSION, AUTHOR, COPYRIGHT AND CONTACT

Version: $VS, date: $DT.
$CP

  This program is provided by the terms
  of the 'GNU GPL' in version 2.
  The original text of the licence could
  be obtained from:
    http://www.gnu.org/licenses/old~
    -licenses/gpl-2.0

  Internet:
    $NET
  Mailbox (V.34):
    $MB
  Contact:
    E-mail   : $EM
    QRA (CB) : $CPQRACB
    QRA (HAM): $CPQRAHAM"
}

FuncDepdfmark() {
	sed -e '/^\.pdfinfo.*/d' \
	-e '/^\.pdfbookmark.*/d' \
	-e '/^\.pdfhref[[:space:]]M[[:space:]]*/d' \
	-e 's/^\.pdfhref[[:space:]].[[:space:]]\-D[[:space:]]'\
'[^[:space:]]*[[:print:]][[:space:]]//'
}


if [ "$#" -gt '2' ] ; then echo "$EA" >&2 ; FuncHelpShort >&2 ; exit 1
	elif [ -r "$1" -a "$2" ] ; then
		case $2 in
			-|'')	FuncDepdfmark < "$1" ;;
			*)
				if [ "$1" != "$2" ] ; then
					FuncDepdfmark < "$1" > "$2"
					else
						echo "$EI" >&2
						FuncHelpShort >&2
						exit 1
				fi
				;;
		esac
	elif [ -r "$1" ] ; then	FuncDepdfmark < "$1"
	else
	case $1 in
		-h*|--help*)	FuncHelpShort ;;
		-v*|--version*)	FuncVersion ;;
		-|'')
		case $2 in
			-|'')	FuncDepdfmark ;;
			*)	FuncDepdfmark > "$2" ;;
		esac
		;;
		-*|--*)	echo "$EO" >&2 ; FuncHelpShort >&2 ; exit 1 ;;
		*)	echo "$EF" >&2 ; FuncHelpShort >&2 ; exit 1 ;;
	esac
fi
