.\" To process for TTY run 'rofftty.sh' and to process for PDF
.\" disable the following '.pl, .ll  and .po' entries and run
.\" 'roffpdf.sh'.
.\"
.\" --[ TABLE OF CONTENTS ]---------------------------------------------
.\"
.\"     SECTION                 LINE
.\"     - DOCUMENT PARAMETERS.....14
.\"     - MACRO DEFINITIONS......138
.\" ==> - DOCUMENT DEFAULTS......680 <==
.\"     - DOCUMENT PREPARATION...693
.\"     - BEGIN OF CONTENT.......711
.\"
.\" --[ DOCUMENT PARAMETERS ]-------------------------------------------
.\" Sets paper size to  A4       for nroff.
.\" .pl 29.7c
.\" Sets line length to 64 chars for nroff.
.\" .ds LL 64n
.\" Sets page offset to  8 chars for nroff.
.\" .po 8
.\"
.\" Distance from top of page to top of header.             Default: 1i.
.\" .nr HM 2.5c
.\" Distance from top of page to top of text.
.\" .nr TM 7v
.\" Distance from bottom of page to bottom of footer:       Default: 1i.
.\" .nr FM 2.5c
.\" Distance from bottom of page to bottom of text.
.\" .nr BM 5v
.\" Redifine tabs.
.ta 4c 4cR
.\" Sets the day register to 2 digits.
.af dy 01
.\" Sets the month register to 2 digits.
.af mo 01
.\" Sets the year register to 4 digits and to current year.
.nr yr +1900
.
.\" Load font families for troff.  Options: 'A,BM,C,CM,H,HN,P,T'.
.\" Sets font of main 'body' text.
.ds BF T
.\" Sets fixed spaced / monospaced font.
.ds MF C
.\" Sets font of headers, footers and headlines.
.ds HF H
.\" Sets font of pictures, graphs, etc.
.ds GF \*(HF
.\" Sets font of formulas.
.ds FF \*(BF
.
.\" For a thesis:
.\" Sets line length to 15 cm.
.\" .ds LL 15c
.\" Sets page offset to 3.5 cm.
.\" .po 3.5c
.\" Paragraph font size: 12p.                              Default: 10p.
.\" .nr PS 12
.\" Paragraph vertical spacing: 18p of 10p -> 1.5x/12p.    Default: 12p.
.\" .nr VS 18
.\" Footnote vertical spacing: 0p.                         Default: +2p.
.\" .nr FVS 0
.
.ds Tl MS-macro document
.ds St Subtitle
.ds Et Seminary thesis
.ds Au Marc Fege
.ds Ad Mainstreet 12, D-12345 City
.ds Ww www.fege.net
.ds Em 13mdf@fege.net
.ds Pn +00 0000 0000000
.ds At Student
.ds Sj General Studies
.ds Sc ABC University
.ds Sw www.example.com
.ds Ai Institution\'s\~name
.ds Aw www.example.com
.ds Cl Class\'s name
.ds Is Instructor\'s\~name
.ds Ei n.n@example.com
.ds Se 01/\n(yr
.ds Da \n(dy.\n(mo.\n(yr
.ds Rv Revision 1
.ds Ed First\~Edition
.ds Pb Publisher
.ds Ct City
.ds Cy the Federal\~Republic\~of\~Germany
.ds In 000-000000000-0
.ds De Laus \s-2D\s-2EO\s+4.
.
.\" '.++C' texts for template headers, footers and figures.
.ds Sn Section
.ds Wc CHAPTER
.ds Wa APPENDIX
.ds Wb BIBLIOGRAPHY
.ds Wp PRELIMINARY
.ds Wt TABLE OF CONTENTS
.ds Fg Figure
.
.\" NOTICE: The following PDF definitions are GROFF-only.
.\" Define PDF link colors.                      Alternatively: #000000.
.ds PDFHREF.COLOUR #0000EE
.defcolor pdf:href.colour rgb \*[PDFHREF.COLOUR]
.\" PDFINFO metadata.
.pdfinfo /Title \*(Tl
.pdfinfo /Author \*(Au
.pdfinfo /Subject How to write a document using the ms macros.
.pdfinfo /Keywords roff groff PDF ms-macros
.
.\" Enables delimeter '`' for inline 'eqn(1)' preprocessor.
.\" Note: '$$' is already reserved for refer(1) references in '$LIST$'.
.EQ
delim ``
.EN
.
.\" Define parameters for 'refer(1)' preprocessor.
.R1
database bibl.ref
discard FGHIUWXYZ
capitalize AQE
# reverse A
join-authors " / " " / " " / "
et-al "\~et\~al." 1 2 # 3
accumulate
.R2
.\" For bracket labelling.
.R1
sort A+Q+L+D+
#sort LAQD
move-punctuation
label "L?L:(D?(@.c|Q.c)',\~'(D.+yD.y%a*D.-y):(@.c|Q.c|T))"
# "L?L:(D?(@.c|Q.c)',\~'(D.+yD.y%a*D.-y):(@.c|Q.c|T))(P&',\~'P)"
# "L?L:(D?(A.n.c|Q.c)',\~'(D.+yD.y%a*D.-y):(A.n.c|Q.c|T))"
# "L?L:(D?(A.n.c|Q.c)',\~'(D.+yD.y%a*D.-y):(A.n.c|Q.c|T))(P&',\~'P)"
bracket-label "\~(" ) "; "
.R2
.
.
.\" --[ MACRO DEFINITIONS ]---------------------------------------------
.\" Define horizontal line strings for headers and footers.
.ds Hl \fB\D't 1p'\v'+1v'\l'-\\n(.lu\(rn'\v'-1v'\D't 0.5p'\fP
.ds Fl \fB\D't 1p'\v'-1v'\l'-\\n(.lu\(ul'\v'+1v'\D't 0.5p'\fP
.
.\" NOTICE: The following header and footer definitions are
.\" Berkeley extentions to the original MS-macro package backported from
.\" the ME-macros.
.\" Predifined standard header.
.de he
.HE "'\F[\*(HF]\fB\fI\*(Tl\fP'\*(Rv'\*(Da\fP\F[\*(BF]\*(Hl'"
..
.\" Predifined standard odd header.
.de oh
.OH "'\F[\*(HF]\fB\fI\*(Tl\fP'\*(Rv'\*(Da\fP\F[\*(BF]\*(Hl'"
..
.\" Predifined standard even header.
.de eh
.EH "'\F[\*(HF]\fB\*(Da'\*(Rv'\fI\*(Tl\fP\fP\F[\*(BF]\*(Hl'"
..
.\" Predifined standard footer.
.de fo
.FO "'\F[\*(HF]\fB\*(Au'\(en % \(en'\*(Ai\fP\F[\*(BF]'"
..
.\" Predefined standard odd footer.
.de of
.OF "'\F[\*(HF]\fB%'\*(Au'\*(Ai\fP\F[\*(BF]\*(Fl'"
..
.\" Predefined standard even footer.
.de ef
.EF "'\F[\*(HF]\fB\*(Ai'\*(Au'%\fP\F[\*(BF]\*(Fl'"
..
.\" Change font size/virtical space macro.
.de sz
.ps \\$1
.\" .vs \\$1
..
.\" Define ++ macro as in '-me'.
.de ++
.ie "\\$1"A" \
\{\
.	nr _M 2
.	af ch A
.\}
.el .af ch 0
.if "\\$1"C" \
\{\
.	nr _M 1
.	af % 0
.	nr % 0
.\}
.if "\\$1"P" \
\{\
.	nr _M 3
.	af % i
.\}
.if "\\$1"B" \
\{\ 
.	nr _M 4
.\}
.if "\\$1"T" \
\{\
.	nr _M 5
.\}
.nr ch 0
..
.\" Like ".+c" with adjusting headers acc. to arg.
.de +C
.OH
.EH
.\" Omit Header on the next page.
.PT
.\" .OH "'\F[\*(HF]\fB% \(br'\*(Au'\*(Ai\fP\F[\*(BF]'"
.\" .EH "'\F[\*(HF]\fB\*(Ai'\*(Au'\(br %\fP\F[\*(BF]'"
.bp
.nr ch +1
.if \\n(_M=1 .ds wc \*(Wc
.if \\n(_M=2 .ds wa \*(Wa
.if \\n(_M=3 .ds wp \*(Wp
.if \\n(_M=4 .ds wb \*(Wb
.if \\n(_M=1 .ds tf \\*(wc\~\\n(ch
.if \\n(_M=2 .ds tf \\*(wa\~\\n(ch
.if \\n(_M=3 .ds tf \\*(wp
.if \\n(_M=4 .ds tf \\*(wb
.if \\n(_M=5 .ds tf
.
.sp
\&
.fam \*(HF
.sz +2
.ce 2
.if !\\n(_M=3 .UL "\\*(tf"
.sp
.sz +4
.B "\\$1"
.sp 2
.sz -6
.fam \*(BF
.
.OF "'\F[\*(HF]\fB% \(br \fI\\*(tf \(bu \\$1\fP'\
\*(Au'\*(Ai\fP\F[\*(BF]\*(Fl'"
.EF "'\F[\*(HF]\fB\*(Ai'\*(Au'\
\fI\\*(tf \(bu \\$1\fP \(br %\fP\F[\*(BF]\*(Fl'"
.if \\n(_M=3 \
\{\
.ds tf \\*(wp
.OF "'\F[\*(HF]\fB% \(br'\*(Au'\*(Ai\fP\F[\*(BF]\*(Fl'"
.EF "'\F[\*(HF]\fB\*(Ai'\*(Au'\(br %\fP\F[\*(BF]\*(Fl'"
.\}
.if \\n(_M=4 \
\{\
.ds tf \\*(wb
.OH "'\F[\*(HF]\fB'\*(Rv'\*(Da\fP\F[\*(BF]\*(Hl'"
.EH "'\F[\*(HF]\fB\*(Da'\*(Rv'\fP\F[\*(BF]\*(Hl'"
.\" .OF "'\F[\*(HF]\fB% \(br \fI\\*(tf\fP\
.\" '\*(Au'\*(Ai\fP\F[\*(BF]\*(Fl'"
.\" .EF "'\F[\*(HF]\fB\*(Ai'\*(Au\
.\" '\fI\\*(tf\fP \(br %\fP\F[\*(BF]\*(Fl'"
.OF "'\F[\*(HF]\fB%'\*(Au'\*(Ai\fP\F[\*(BF]\*(Fl'"
.EF "'\F[\*(HF]\fB\*(Ai'\*(Au'%\fP\F[\*(BF]\*(Fl'"
.\}
.\" Reset figure counter.
.nr fg 0
..
.\" Like '.SH', but with adjusting fonts.
.de h0
.ds FAM \*(HF
.SH
\\$1
.ds FAM \*(BF
..
.\" Like '.SH', but with adjusting fonts & headers acc. to args.
.de sh
.ds FAM \*(HF
.SH
\\$1
.ds FAM \*(BF
.OH "'\F[\*(HF]\fB\fR\*(Sn \(bu \fP\fI\\$1\fP'\*(Rv'\
\*(Da\fP\F[\*(BF]\*(Hl'"
.EH "'\F[\*(HF]\fB\*(Da'\*(Rv'\
\fR\*(Sn \(bu \fP\fI\\$1\fP\fP\F[\*(BF]\*(Hl'"
..
.\" Like '.NH', but with adjusting fonts.
.de h1
.ds FAM \*(HF
.NH \\$1
.XN "\\$2"
.ds FAM \*(BF
..
.\" Like '.NH', but with adjusting fonts & headers acc. to args.
.de nh
.ds FAM \*(HF
.NH \\$1
.XN "\\$2"
.ds FAM \*(BF
.OH "'\F[\*(HF]\fB\fR\*(Sn \(bu \fP\fI\\*(SN \\$2\fP'\
\*(Rv'\*(Da\fP\F[\*(BF]\*(Hl'"
.EH "'\F[\*(HF]\fB\*(Da'\*(Rv'\
\fR\*(Sn \(bu \fP\fI\\*(SN \\$2\fP\fP\F[\*(BF]\*(Hl'"
..
.\" Title Header.
.de HT
.fam \*(HF
.B
.sz +6
\*(Tl
.sz -6
.R
.fam \*(BF
.sp
..
.\" Figcapture.
.de FI
.\" Add 1 on figure counter 'fg' on each call.
.nr fg +1
.br
.sz -2
.fam \*(HF
.ie '\\n(ch'0' \fB\*(Fg\~\\n(fg:\fP
.el \fB\*(Fg\~\\n(ch.\\n(fg:\fP
.I
\\$1
.R
.fam \*(BF
.br
.sz +2
..
.\" Initial capital letter + indentation (dropcap).  End with '.EI'.
.de IN
.in +0.3i
.ti -0.3i
\v'2'\s(\\$2\\$1\s0\v'-2'\c
..
.\" End initial capital letter indentation.
.de EI
.in -0.3i
..
.\" Draw horizontal line as in '-me' macros.
.de HL
.br
.if '\*(.T'html' \
\{\
.       HR
.       do return
.\}
.ie \n(.g .do nr _I \\n[.in]
.el .nr _I \\n(.i
\l'\\n(.lu-\\n(_Iu'
.sp
..
.\" Like '.HL', but draws a horizontal overline with the '\(rn' char.
.de OL
.sp
.if '\*(.T'html' \
\{\
.       HR
.       do return
.\}
.ie \n(.g .do nr _I \\n[.in]
.el .nr _I \\n(.i
\l'\\n(.lu-\\n(_Iu\(rn'
.br
..
.\" Wrapper for pictures for PDF or other targets.  GROFF-only!
.de PC
.ie '\*(.T'pdf' .PDFPIC "\\$1" "\\$2.pdf"
.el \
\{\
.	PSPIC "\\$1" "\\$2.eps"
.\" .PE' to prevent misinterpretation of '.PSPIC' as '.PS'.
.	PE
.\}
..
.\" Code box. End with '.b2'.  If $1 is '1', activate line numbering.
.de b1
.ds bt \\$1
.B1
.fam \*(MF
.if '\\*(bt'1' .nm 1 1 4 -1
.sp 0.2
..
.\" End Code box.
.de b2
.sp .3
.if '\\*(bt'1' .nm
.fam \*(BF
.B2
.rm bt
..
.\" Define a 'middle mark' macro with 3 centered diamonds as seperators.
.de MM
.sp
.ce
.sz +4
\(**\~\(**\~\(**
.sz -4
.sp
..
.\" Define an 'end mark' macro for a square at the end of an article.
.de EM
.if '\*(.T'ascii'\(sq
.ie '\*(.T'ascii8'\(sq
.ie '\*(.T'cp1047'\(sq
.ie '\*(.T'latin1'\(sq
.ie '\*(.T'utf8'\(sq
.el \
\{\
.defcolor Crimson rgb #DC143C
\M[Crimson]\D'\P 0m -.75m .75m 0m 0m .75m'\M[]
.\}
..
.\" Automatic printout of fonts acc. to settings above. Edit as desired.
.if '\*(BF'A' .ds Bf Avant\~Garde
.ie '\*(BF'BM' .ds Bf Bookman
.ie '\*(BF'CM' .ds Bf Computer\~Modern
.ie '\*(BF'C' .ds Bf Courier
.ie '\*(BF'H' .ds Bf Helvetica
.ie '\*(BF'P' .ds Bf Palatino
.ie '\*(BF'T' .ds Bf Times\~Roman
.if '\*(MF'A' .ds Mf Avant\~Garde
.ie '\*(MF'BM' .ds Mf Bookman
.ie '\*(MF'CM' .ds Mf Computer\~Modern
.ie '\*(MF'C' .ds Mf Courier
.ie '\*(MF'H' .ds Mf Helvetica
.ie '\*(MF'P' .ds Mf Palatino
.ie '\*(MF'T' .ds Mf Times\~Roman
.if '\*(HF'A' .ds Hf Avant\~Garde
.ie '\*(HF'BM' .ds Hf Bookman
.ie '\*(HF'CM' .ds Hf Computer\~Modern
.ie '\*(HF'C' .ds Hf Courier
.ie '\*(HF'H' .ds Hf Helvetica
.ie '\*(HF'P' .ds Hf Palatino
.ie '\*(HF'T' .ds Hf Times\~Roman
.
.\" Define a 'title page' macro.
.\" If $1 is 'de', then a notice in German will be printed.
.\" Otherhise English output is prompted.  $2 represents the logo file.
.de tp
.nr TV \\n(tv
.nr VS 12
.fam \*(HF
.ie '\\$2'' \
\{\
.sp 12
.ce
.B
.pdfhref W -D https://\*(Sw \*(Sc
.R
.\}
.el .PC -C "\\$2"
.sp 2
.ie '\\$1'de' \
\{\
\fBLehrstuhl:\fP	\c
.pdfhref W -D https://\*(Aw \*(Ai
.br
\fBSeminar:\fP	\*(Cl
.br
\fBBetreuer:\fP	\c
.pdfhref W -D mailto:\*(Ei \*(Is
.br
\fBeingereicht:\fP	\*(Se
.\}
.el \
\{\
\fBInstitute:\fP	\c
.pdfhref W -D https://\*(Aw \*(Ai
.br
\fBClass:\fP	\*(Cl
.br
\fBInstructor:\fP	\c
.pdfhref W -D mailto:\*(Ei \*(Is
.br
\fBsubmitted:\fP	\*(Se
.\}
\fB\D't 3p'
.HL
\D't 0.5p'\fP
.sz +10
.sp
\fB\*(Et:\fP
.sz -10
.sz +20
.sp 4
\fB\*(Tl\fP
.sz -10
.sp 4
\fB\*(St\fP
\fB\D't 3p'
.HL
\D't 0.5p'\fP
.sz -4
.B
.pdfhref W -D mailto:\*(Em \*(Au
.R
.sz -6
.sp 2
\*(Pb
.sp 4
.ie '\\$1'de' \
\{\
\fBVerfasser:\fP	\c
.pdfhref W -D mailto:\*(Em \*(Au
.br
\fBStudienfach:\fP	\*(Sj
.br
\fBAnschrift:\fP	\*(Ad
.br
\fBTelephon:\fP	\*(Pn
.br
\fBE-Mail:\fP	\c
.pdfhref W -D mailto:\*(Em \*(Em
.\}
.el \
\{\
\fBAuthor:\fP	\c
.pdfhref W -D mailto:\*(Em \*(Au
.br
\fBSubject:\fP	\*(Sj
.br
\fBAddress:\fP	\*(Ad
.br
\fBPhone:\fP	\*(Pn
.br
\fBE-mail:\fP	\c
.pdfhref W -D mailto:\*(Em \*(Em
.\}
.nr VS \\n(TV
..
.\" Define a 'creation notice' macro on how this article was created.
.\" If $1 is 'de', then a notice in German will be printed.
.\" Otherwise English output will be prompted.
.de cn
.fam \*(HF
.LP
.KS
.sz -2
.HL
.b Erstellungshinweis:
.br
.I
.ie '\\$1'de' \
\{\
.B Erstellungshinweis:
.br
Dieser Artikel wurde geschrieben und gesetzt unter Zuhilfenahme von
\s-1G\s-1ROFF\s+2 mit den \s-1m\s-1s\s+2-Macros, \s-1G\s-1HOSTSCRIPT\s+2
und anderen quelloffenen \s-1U\s-1NIX\s+2-Werkzeugen.
.\}
.el \
\{\
.B "Creation notice:"
.br
This article has been written and typeset using \s-1G\s-1ROFF\s+2 with
\s-1m\s-1s\s+2-macros, \s-1G\s-1HOSTSCRIPT\s+2 and other open\~source
\s-2U\s-1NIX\s+3\~tools.
.\}
.R
.br
.sz +2
.KE
.fam \*(BF
..
.\" Define a 'copyright notice' macro on how this article was created.
.\" If $1 is 'de', then a notice in German will be printed.
.\" Otherwise English output will be prompted.
.de cr
.nr TV \\n(VS
.nr VS 12
.bp
.fam \*(BF
\&
.sp 9
.ce 25
Copyright\~\(co\~\n(yr\~\c
.pdfhref W -D mailto:\*(Em \*(Au.
.sp
.ie '\\$1'de' \
\{\
\*(Pb, \*(Ct.
.sp
\*(Ed.
.sp 2
.pdfhref W -D https://\*(Ww \*(Ww
.br
.pdfhref W -D mailto:\*(Em \*(Em
.sp
Alle Rechte vorbehalten.
Ohne die vorhergehende schriftliche Zustimmung darf kein Teil
dieses Werks in irgendeiner Form oder mit irgendwelchen Mitteln
elektronisch, mechanisch, per Photokopie, per Aufzeichnung oder
auf andere Weise reproduziert, in einem R\(:uckgewinnungssystem
gespeichert oder \(:ubertragen werden.
.sp
ISBN\~\*(In
.sp
Die Druckvorlage f\(:ur dieses Buch wurde durch den Autor gesetzt
.br
in \F[\*(BF]\fI\*(Bf\fP\F[\*(BF], \F[\*(MF]\fI\*(Mf\fP\F[\*(BF] und \
\F[\*(HF]\fI\*(Hf\fP\F[\*(BF]
.br
unter Zuhilfenahme von \s-2G\s-1ROFF\s+3 mit den \
\s-2m\s-1s\s+3-Macros, \s-2G\s-1HOSTSCRIPT\s+3
.br
und anderen quelloffenen \s-2U\s-1NIX\s+3-Werkzeugen.
.sp
\s-2G\s-1HOSTSCRIPT\s+3 ist ein eingetragenes Warenzeichen der \c
\fI\c'
.pdfhref W -D https://artifex.com Artifex Software, Inc.\fP
\s-2G\s-1ROFF\s+3 ist Teil des \fI\c
.pdfhref W -D https://www.gnu.org GNU-\&Projekts\fP.
\s-2H\s-1ELVETICA\s+3, \s-2I\s-1TC\~AVANT\~GARDE\s+3, \c
\s-2I\s-1TC\~BOOKMAN\s+3 und \c
\s-2T\s-1IMES\~ROMAN\s+3 sind
.br
eingetragene Warenzeichen der \fI\c
.pdfhref W -D https://www.monotype.com Monotype Imaging Holdings, Inc.\
\fP
\s-2P\s-1ALATINO\s+3 ist ein eingetragenes Warenzeichen der \fI\c
.pdfhref W -D https://www.heidelberg.com Heidelberger Druckmaschinen \
AG\fP.
\s-2U\s-1NIX\s+3 ist ein eingetragenes Warenzeichen von \fI\c
.pdfhref W -D https://www.opengroup.org The Open Group\fP.
.sp 2
Gedruckt auf s\(:aure- und chlorfrei gebleichtem Papier. \(if
.sp
Gedruckt in \*(Cy.
.\}
.el \
\{\
Published by \*(Pb, \*(Ct.
.sp
\*(Ed.
.sp 2
.pdfhref W -D https://\*(Ww \*(Ww
.br
.pdfhref W -D mailto:\*(Em \*(Em
.sp
All rights reserved.
No part of this publication may be reproduced, stored
in a retrieval system, or transmitted, in any form or by
any means, electronic, mechanical, photocopying, recording, or
otherwise, without prior written permission of the publishers.
.sp
ISBN\~\*(In
.sp
Camera-ready copy for this book was produced by the author
.br
in \F[\*(BF]\fI\*(Bf\fP\F[\*(BF], \F[\*(MF]\fI\*(Mf\fP\F[\*(BF] and \
\F[\*(HF]\fI\*(Hf\fP\F[\*(BF],
.br
using \s-2G\s-1ROFF\s+3 with \
\s-2m\s-1s\s+3-macros, \s-2G\s-1HOSTSCRIPT\s+3
.br
and other open\~source \s-2U\s-1NIX\s+3\~tools.
.sp 2
\s-2G\s-1HOSTSCRIPT\s+3 is a registered trademark of \c
\fI\c'
.pdfhref W -D https://artifex.com Artifex Software, Inc.\fP
\s-2G\s-1ROFF\s+3 is part of the \fI\c
.pdfhref W -D https://www.gnu.org GNU Project\fP.
\s-2H\s-1ELVETICA\s+3, \s-2I\s-1TC\~AVANT\~GARDE\s+3, \c
\s-2I\s-1TC\~BOOKMAN\s+3 and \c
\s-2T\s-1IMES\~ROMAN\s+3 are
.br
registered trademarks of \fI\c
.pdfhref W -D https://www.monotype.com Monotype Imaging Holdings, Inc.\
\fP
\s-2P\s-1ALATINO\s+3 is a registered trademark of \fI\c
.pdfhref W -D https://www.heidelberg.com Heidelberger Druckmaschinen \
AG\fP.
\s-2U\s-1NIX\s+3 is a registered trademark of \fI\c
.pdfhref W -D https://www.opengroup.org The Open Group\fP.
.sp 2
Printed on acid- and chlorine-free paper. \(if
.sp
Printed in \*(Cy.
.\}
.sp
10  9  8  7  6  5  4  3  2  1
.nr VS \\n(TV
..
.\" ==[ DOCUMENT DEFAULTS ]=============================================
.\" Default preparing page macro with headers, footers and body font.
.de dp
.ds FAM \*(BF
.\" .he
.oh
.eh
.\" .fo
.of
.ef
..
.
.
.\" -=[ DOCUMENT PREPARATION ]=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
.\" to empty the center header.
.ds CH
.\" .RP
.\" .
.\" .TL
.\" \*(Tl
.\" .AU
.\" \*(Au
.\" .AI
.\" \*(Ai
.\" .DA
.\" \*(Da
.\" .ND
.\" \*(Da
.\" .
.\" .dp
.
.\" ==[ END OF DOCUMENT PREPARATION / BEGIN OF CONTENT ]================
.
.\" --- Title page -----------------------------------------------------
.tp
.
.\" --- Copyright page -------------------------------------------------
.cr
.
.\" --- Dedication page ------------------------------------------------
.bp
\&
.sp 24
.ce
\s+6\*(De\s-6
.
.\" --- Actual document contents ---------------------------------------
.++ P
.\" .of
.\" .ef
.
.ds FAM \*(HF
.\" Postprocessing: move the table of contents from the end here.
.if '\*(.T'pdf' \X'pdf: pagename TOC'
.ds FAM \*(BF
.\" Sets line spacing to 2 lines.
.\" .ls 2
.\" .AB
.\" After the preliminary pages reset to -ms defaults -> .TL is lacking.
.RT
.+C ABSTRACT
.QS
.I
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
.R
.QE
.\" .AE
.++ C
.+C "SIDE NOTES"
.ds FAM \*(BF
.\" These tables emulate sidenote paragraphs.
.TS
lw(3c) lx.
T{
.fam \*(HF
\&
.sp 1.3
.ps -2
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore.
.ps +2
.fam \*(BF
T}	T{
.nh 1 "First Heading"
.PP
.IN L +26
orem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
.EI
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
T}
.TE
.TS
lw(3c) lx.
\&	T{
.QP
\(lq\c
.i "In the beginning"
was the
.b Word ,
and the
.b Word
was with
.b God ,
and the
.b Word
was
.b God .\(rq\c
\~\(en\~Gospel of
.i "John\~1:1" .
.[
BOOK_KJV
.]
T}
.TE
.TS
lw(3c) lx.
\&	T{
.PP
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
T}
.TE
.TS
lw(3c) lx.
T{
.fam \*(HF
\&
.sp 1.3
.ps -2
.fam \*(FF
`x sub 1,2 = { -b +- sqrt { b sup 2 - 4ac } } over 2a`
.fam \*(HF
.FI "Example of a figcapture on an 'eqn(1)' formula: Quadratic formula."
.ps +2
.fam \*(BF
T}	T{
.nh 1 "Second Heading"
.LP
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
T}
.TE
.TS
lw(3c) lx.
\&	T{
.PP
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
T}
.TE
.TS
lw(3.25c)   l   s   sx
^      | l   s   s |
^      | l   s   s |
^      | l   s | l |
^      | l   s | l |
^      | l | l | l |
^      | l | l | l |
^      | l | l | l |
^      | l | l | l |
^        l   s   s.
\&	_
\&	\fBTITLE
\&	_
\&	FOO	BAR\fP
\&	_	_
\&	foo	bar	bar
\&	_	_	_
\&	foo	foobar	foobar
\&	_	_	_
\&	T{
.FI "Example of a figcapture on a table."
T}
.TE
.TS
lw(3c) lx.
\&	T{
.PP
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
T}
.TE
.TS
lw(3c) lx.
T{
.fam \*(HF
\&
.sp 1.3
.ps -2
Lorem ipsum dolor sit amet, consectetur adipiscing elit.
.ps +2
.fam \*(BF
T}	T{
.nh 1 "Third Heading"
.LP
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
T}
.TE
.TS
lw(3c) lx.
\&	T{
.KF
.HL
.\" Graph description is following for 'grap' between '.G1' and '.G2'.
.fam \*(GF
.G1
frame invis ht 2 wid 4 left solid bot solid
label left "y" "(bits)" left .15
label bot "x" "(base)"
coord x 0,7 y 0,128
ticks left out from 0 to 128 by 16
ticks bot out from 0 to 7 by 1
grid left from 16 to 128 by 16 ""
grid bot from 1 to 7 by 1 ""
draw solid color "magenta"
for x from 0 to 7 by .1 do { next at x, 2^x }
draw dashed color "lightseagreen"
for x from 0 to 7 do { next at x, x^2 }
"0 circle" color "forestgreen" above at 0.35,0.1
circle at 0,0 color "forestgreen"
"2 bullet" color "forestgreen" above at 1,2
bullet color "forestgreen" at 1,2
"4 delta" color "forestgreen" above at 2,4
delta color "forestgreen" at 2,4
"8 times" color "forestgreen" above at 2.9,8
times color "forestgreen" color "forestgreen" at 3,8
"16 square" color "forestgreen" ljust at 4.2,16
square color "forestgreen" at 4,16
"32 star" color "forestgreen" ljust at 5.1,32
star color "forestgreen" at 5,32
"64 box" color "forestgreen" ljust at 6.1,64
box color "forestgreen" at 6,64
"128 vtick" color "forestgreen" rjust at 6.9,128
vtick color "forestgreen" at 7,128
.G2
.fam \*(BF
.FI "Example of a figcapture on a grap(1) graph for \c
`y sub 1~=~2 sup x` in magenta and for \c
`y sub 2~=~x sup 2` in dark sea green.
.HL
.KE
T}
.TE
.TS
lw(3c) lx.
\&	T{
.PP
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
T}
.TE
.TS
lw(3c) lx.
T{
.fam \*(HF
.ps -2
Lorem ipsum dolor sit amet, consectetur adipiscing elit.
.ps +2
.fam \*(BF
T}	T{
.PP
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
T}
.TE
.TS
lw(3c) lx.
T{
.fam \*(HF
\&
.sp 1.3
.ps -2
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore.
.ps +2
.fam \*(BF
T}	T{
.nh 1 "Fouth Heading"
.LP
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
T}
.TE
.TS
lw(3c) lx.
T{
.fam \*(HF
\&
.sp 1.3
.ps -2
Lorem ipsum dolor sit amet, consectetur adipiscing elit.
.ps +2
.fam \*(BF
T}	T{
.nh 1 "Fifth Heading"
.KF
.fam \*(FF
.\" Chemical description for 'chem(1)' preprocessor for 'pic(1)'.
.cstart
R: ring5 put O at 1 double 3,4
double bond 70 from R.V2 ; O
bond 140 from R.V3 ; OH
bond 220 from R.V4 ; HO
back bond 0 from R.V5 ; H
bond 290 from R.V5 ; BP
bond 230
bond 290 ; HO
back bond 350 from BP ; HO
.cend
.fam \*(BF
.FI "Example of figcapture of a 'chem(1)' formula on L-Ascorbic\~acid \
(C\*<6\*>H\*<8\*>O\*<6\*>)."
.KE
T}
.TE
.TS
lw(3c) lx.
\&	T{
.LP
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
T}
.TE
.TS
lw(3c) lx.
T{
.fam \*(HF
\&
.sp 1.3
.ps -2
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore.
.ps +2
.fam \*(BF
T}	T{
.nh 1 "Sixth Heading"
.LP
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
.KF
.fam \*(FF
.EQ
DELTA v = v sub e ln m sub 0 over m sub f
= I sub sp g sub 0 ln m sub 0 over m sub f
.EN
.fam \*(BF
.FI "Example figcapture on an 'eqn(1)' formula: \
Tsiolkovsky rocket equation."
.KE
T}
.TE
.TS
lw(3c) lx.
\&	T{
.PP
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
T}
.TE
.TS
lw(3c) lx.
T{
.fam \*(HF
\&
.sp 1.3
.ps -2
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore.
.ps +2
.fam \*(BF
T}	T{
.nh 1 "Seventh Heading"
.LP
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
T}
.TE
.+C "TWO COLUNS"
.ds FAM \*(BF
.\" Sets two column mode for text from this page onward.
.2C
.nh 1 Introduction
.PP
.IN L +26
orem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
.EI
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
.QP
\(lq\c
.I "In the beginning"
was the
.B Word ,
and the
.B Word
was with
.B God ,
and the
.B Word
was
.B God .\(rq\c
\~\(en\~Gospel of
.I "John\~1:1" .
.[
BOOK_KJV
.]
.PP
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
.HL
.nh 1 Content
.PP
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
.nh 2 "Subcontent 1"
.PP
.I
Lorem ipsum.
.R
.sp
.KF
.B "A bulleted list:"
.IP \(bu
Type A
.IP \(bu
Type B
.IP \(bu
Type C
.KE
.nh 2 "Subcontent 2"
.sp
.KF
.B "A numbered list:"
.nr i 0 1
.IP (\n+i)
Type A
.IP (\n+i)
Type B
.IP (\n+i)
Type C
.KE
.PP
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
.KF
.HL
.PC -C "figure1"
.FI "Example of a figcapture on a picture."
.HL
.KE
.PP
Lorem ipsum.
.KF
.HL
.\" Table description is following for 'tbl' between '.TS' and '.TE'.
.TS
allbox expand;
l s s
l s l
l l l.
\fBTITLE
FOO	BAR\fP
foo	bar	bar
foo	foobar	foobar
.TE
.FI "Example of a figcapture on a table."
.HL
.KE
.\" Code box. End with '.b2'.  If $1 is '1', activate line numbering.
.b1 0
Lorem ipsum dolor
.br
\&	sit amet,
.br
consectetur.
.b2
.FI "Example of a figcapture on a code listing."
.PP
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
.HL
.\".bc
.nh 1 "Conclusion 1"
.PP
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
.br
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo.
.bp
\&
.bp
\&
.1C
.+C AFTERWORD
.KF
.HL
.\" Graph description is following for 'grap' between '.G1' and '.G2'.
.fam \*(GF
.G1
frame invis ht 3 wid 5 left solid bot solid
label left "y" "(bits)" left .15
label bot "x" "(base)"
coord x 0,7 y 0,128
ticks left out from 0 to 128 by 16
ticks bot out from 0 to 7 by 1
grid left from 16 to 128 by 16 ""
grid bot from 1 to 7 by 1 ""
draw solid color "magenta"
for x from 0 to 7 by .1 do { next at x, 2^x }
draw dashed color "lightseagreen"
for x from 0 to 7 do { next at x, x^2 }
"0 circle" color "forestgreen" above at 0.35,0.1
circle at 0,0 color "forestgreen"
"2 bullet" color "forestgreen" above at 1,2
bullet color "forestgreen" at 1,2
"4 delta" color "forestgreen" above at 2,4
delta color "forestgreen" at 2,4
"8 times" color "forestgreen" above at 2.9,8
times color "forestgreen" color "forestgreen" at 3,8
"16 square" color "forestgreen" ljust at 4.2,16
square color "forestgreen" at 4,16
"32 star" color "forestgreen" ljust at 5.1,32
star color "forestgreen" at 5,32
"64 box" color "forestgreen" ljust at 6.1,64
box color "forestgreen" at 6,64
"128 vtick" color "forestgreen" rjust at 6.9,128
vtick color "forestgreen" at 7,128
.G2
.fam \*(BF
.FI "Example of a figcapture on a grap(1) graph for \c
`y sub 1~=~2 sup x` in magenta and for \c
`y sub 2~=~x sup 2` in dark sea green.
.HL
.KE
.2C
.nh 1 "Conclusion 2"
.PP
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi
ut aliquip ex ea commodo consequat.
.HL
.KF
.\" Table description is following for 'tbl' between '.TS' and '.TE'.
.TS
allbox expand;
l s s
l s l
l l l.
\fBTITLE
FOO	BAR\fP
foo	bar	bar
foo	foobar	foobar
.TE
.FI "Example of a figcapture on a table."
.HL
.KE
.KF
.fam \*(FF
.EQ
x sub 1,2 = { -b +- sqrt { b sup 2 - 4ac } } over 2a
.EN
.fam \*(BF
.FI "Example of a figcapture on an 'eqn(1)' formula: Quadratic formula."
.HL
.KE
.KF
.\" Chemical description for 'chem(1)' preprocessor for 'pic(1)'.
.fam \*(FF
.cstart
R: ring5 put O at 1 double 3,4
double bond 70 from R.V2 ; O
bond 140 from R.V3 ; OH
bond 220 from R.V4 ; HO
back bond 0 from R.V5 ; H
bond 290 from R.V5 ; BP
bond 230
bond 290 ; HO
back bond 350 from BP ; HO
.cend
.fam \*(BF
.FI "Example of figcapture of a 'chem(1)' formula on L-Ascorbic\~acid \
(C\*<6\*>H\*<8\*>O\*<6\*>)."
.KE
.
.1C
.++ A
.+C Drawings
.sh Compilation
.KF
.PP
This template was possible by studying the
.I "man pages"
of the
.I "groff"
and
.I "nroff"
text processing facilities, as well as by reading the paper of
.I "Lary\~Kollar"
and
.I "G.\~Branden\~Robinson" .
.[
MANUAL_groffMS
.]
.\" Pic description is following for 'pic(1)' between '.PS' and '.PE'.
.fam \*(GF
.PS
A: box rad .05 "Bibliograpy" "(bibl.ref)" wid 1 \
	shaded "gold"; move 1.5;
B: box rad .05 "Draft" "(book.ms)" wid 1 \
	shaded "forestgreen"; move 1.5;
C: box rad .05 "Paper" "(book.pdf)" wid 1;
arrow right from A.e to B.w "markup" above;
arrow right from B.e to C.w "roffpdf.sh" above;
CArc: arc rad .4 down cw from C.s;
AArc: arc rad .4 down from A.s <-;
line from CArc.s to AArc.s "correct, if necessary" above;
.PE
.fam \*(BF
.FI "Example of a figcapture on a 'pic(1)' drawing."
.HL
.KE
.sh "Technical Drawing"
.fam \*(BF
.KF
.fam \*(GF
.PS
Ex:	circle rad 1 at 0,0 shaded "tan";
Tamper:	circle rad .85 at 0,0 shaded "navy";
U238:	circle rad .8 at 0,0 shaded "maroon";
Pu239:	circle rad .5 at 0,0 shaded "darkorange";
Init:	circle rad .15 at 0,0 shaded "lightgray" "init\*<n\*>";
"Tamper:" at 0,.65;
"Core:" at 0,.3;
"Pu\*<239\*>" at 0,-.3;
"U\*<238\*>" at 0,-.65;
line from 1.3,.9 to 2.7,.9 "Neutron initiator" above;
line from 1/2 of the way between Init and Init.e to last line.w;
line from 1.3,.6 to 2.7,.6 "Plutonium core" above;
line from 1/2 of the way between Init.e and Pu239.e to last line.w;
line from 1.3,.3 to 2.7,.3 "Tamper/Pusher" above;
line from 1/2 of the way between Pu239.e and U238.e to last line.w;
line from 1.3,-.6 to 2.7,-.6 "Neutron reflector: Be\*<4\*>" above;
line from 1/2 of the way between U238.e and Tamper.e to last line.w;
line from 1.3,-.3 to 2.7,-.3 "Explosive lenses" above;
line from 1/2 of the way between Tamper.e and Ex.e to last line.w;
.PE
.fam \*(BF
.FI "Further example of a conceptual 'pic(1)' drawing of the \
fat\~man nuclear device."
.HL
.KE
.KS
.fam \*(FF
.EQ
DELTA v = v sub e ln m sub 0 over m sub f
= I sub sp g sub 0 ln m sub 0 over m sub f
.EN
.fam \*(BF
.FI "Example figcapture on an 'eqn(1)' formula: \
Tsiolkovsky rocket equation."
.HL
.KE
.fam \*(GF
.KF
.defcolor intblue rgb #00357F
.defcolor intorange rgb #FFAA00
.defcolor intred rgb #DB0912
.PS
CD: box wid 1 ht 1 shaded "intorange" at -2,0;
"\M[intblue]\D'P -3 -4 -3 4'\M[]" at 1/2 <CD.s,CD>;

RC: box shaded "white" wid 1.5 ht 1 at 0,0;
box outline "intred" shaded "intred" ht 0.2 wid 0.7 at RC;
box outline "intred" shaded "intred" ht 0.7 wid 0.2 at RC;

CP: box outline "intblue" shaded "white" wid 0.55 ht 0.50 at 1.75,0.15;
"\M[intblue]\D'P 4 3 -2 1.67 -2 -1.67 4 -3'\M[]" at -1/8 <CP.n,CP>;
.PE
.fam \*(BF
.FI "International protective signs featuring 'pic(1)' and polygons."
.KE
.bp
\&
.
.\" --- References Section ---------------------------------------------
.++ B
.+C References
.\" Disable hyphenation for better interaction with 'refer(1)'.
.hy 0
.[
$LIST$
.]
.\" .R1
.\" discard FGHIUWXYZ
.\" sort A+Q+L+D+
.\" #sort LAQD
.\" label "L?L:(D?(@.c|Q.c)',\~'(D.+yD.y%a*D.-y):(@.c|Q.c|T))"
.\" # "L?L:(D?(A.n.c|Q.c)',\~'(D.+yD.y%a*D.-y):(A.n.c|Q.c|T))"
.\" bracket-label "\~(" ) "; "
.\" bibliography bibl.ref
.\" .R2
.\" .++ T
.hy
.\" Postprocessing: move Table of contents up.
.if '\*(.T'pdf' \X'pdf: switchtopage after TOC'
.\" .+C "\*(Wt"
.\" .PX no
.TC
