#!/bin/sh
# Gloria eo in caelo.
#
#
# LICENSE: GNU GPL 2.0.
# cpcc(6) Jurassic Park Control Console, Dennis Nedry edition.
# Copyright (C) 2023-25, Marc Fege alias 13MDF / DN9MF.
# E-Mail: 13mdf@fege.net
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License version 2
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
# MA 02110-1301, USA.
#
#
# DESCRIPTION:
# This is the CPCC 'Central Park Control Console' of the Jurassic Park
# System Security Interface.  Your job is to keep the system up and
# running and get the dinosaurs back in their enclosures before it is
# too late.  Don't forget the magic word!


CP="Copyright (C) 2023-25, Marc Fege."
PN="`basename $0`"
EM='13mdf@fege.net'
VS='1.0'
DI='2023-12-24'
DT='2025-02-13'
CPQRACB='13MDF'
CPQRAHAM='DN9MF'
NET='https://www.fege.net/software'
MB='[none]'
SYS="`uname -s`"

EA=' ERROR: No options except -v and -h are available!'
EN=' ERROR: too many arguments!  Max: 1.'

IN1="access security"
IN2="access security grid"
IN3="access main security grid"
R1="access: PERMISSION GRANTED."
R2="exiting..."
E1="access: PERMISSION DENIED."
E1u="access: PERMISSION DENIED.\c"
E2="...and..."
E2u="...and...\c."
EP="YOU DIDN'T SAY THE MAGIC WORD!"
EB="\a"
EBB="\a\c"
ES=": must specify target system"


FuncHelpShort() {
echo "CALLING: $PN
  -h, --help     Prints out this help.
  -v, --version  Version, date, license.

DESCRIPTION:
  This is the CPCC 'Central Park Control Console' of the Jurassic Park
  System Security Interface.  Your job is to keep the system up and
  running and get the dinosaurs back in their enclosures before it is
  too late.  Don't forget the magic word!"
}


FuncVersion() {
echo "VERSION, AUTHOR, COPYRIGHT AND CONTACT

Version: $VS, date: $DT.
$CP

  This program is provided by the terms
  of the 'GNU GPL' in version 2.
  The original text of the licence could
  be obtained from:
    http://www.gnu.org/licenses/old~
    -licenses/gpl-2.0

  Internet:
    $NET
  Mailbox (V.34):
    $MB
  Contact:
    E-mail   : $EM
    QRA (CB) : $CPQRACB
    QRA (HAM): $CPQRAHAM"
}


FuncSysCheck () {
	if [ "$KSH_VERSION" -o "$FCEDIT" ] ; then
			sh="u"
		elif [ "$SYS" = "IRIX" -o "$SYS" = "unix" -o "$SYS" = "IS/WB" ] ; then
			sh="u"
		else
			unset sh
			case $SYS in
				*BSD|Minix|Darwin)	sh=b ;;
			esac
	fi
}


FuncInput () {
	case $sh in
		b|"")	read -p "> " m ;;
		u)	echo "> \c" ; read m ;;
	esac
}

FuncVer() {
echo "Jurassic Park, System Security Interface"
echo "Version 4.0.5, Alpha E"
}


if [ "$#" -gt 1 ] ; then echo "$EN" >&2 ; FuncHelpShort >&2 ; exit 1
else
case $1 in
		-h*|--help*)	FuncHelpShort ;;
		-v*|--version*)	FuncVersion ;;
		'')
FuncSysCheck
clear
FuncVer
echo "Ready..."

mc=0
while : ; do
	FuncInput
	case $m in
		access*)
			case $m in
				access)	echo $m$ES ;;
				*[Pp][Ll][Ee][Aa][Ss][Ee]*)	sleep 1
					mc=0
					echo $R1
					echo "YOU SAID THE MAGIC WORD!"
					;;
				*)
					mc=$(($mc+1))
					sleep 1
					if [ $mc -lt 3 ] ; then
						case $sh in
							u)	echo $EB$E1 ;;
							*)	echo -e $EB$E1 ;;
						esac
					else
						case $sh in
							u)	echo $EB$E1u ;;
							b)	echo -e $EBB ; echo -n $E1 ;;
							*)	echo -ne $EB$E1 ;;
						esac
						sleep 1
						case $sh in
							u)	echo $E2u ;;
							*)	echo -n $E2 ;;
						esac
						sleep 1
						echo ""
						case $sh in
							u)	echo $EBB ;;
							b)	echo -e $EBB ;;
							*)	echo -ne $EB ;;
						esac
						while : ; do
							mw=0
							until [ $mw -eq 24 ] ; do
								echo $EP
								mw=$(($mw+1))
							done
							sleep 1
							case $sh in
								u)	echo $EBB ;;
								b)	echo -e $EBB ;;
								*)	echo -ne $EB ;;
							esac
						done
					fi
					;;
			esac
			;;
		[Cc]*)	clear ;;
		[Dd]*)
			case $m in
				[Dd]|display)
							case $sh in
								u)	echo $EB"no file specified" ;;
								*)	echo -e $EB"no file specified" ;;
							esac
							;;
				[Dd]\ *|display\ *)	cat $(echo $m | cut -f 2 -d ' ') ;;
			esac
			;;
		[Kk]*)	echo $ks | xargs -n 1 ;;
		ls)	ls ;;
		[Qq]|[Qq]uit|[Ee]|[Ee]xit|"")	echo $R2
					sleep 1
					exit 0
					;;
		[Hh]*|\?)
			echo "access    - access a target environment on the Jurassic Systems grid"
			echo "clear     - clear the screen"
			echo "display   - display file of an entered name"
			echo "gr_osview - display system processes"
			echo "help      - list available commmands"
			echo "keychecks - display system level command history"
			echo "ls        - list files in the current directory"
			echo "man       - display reference manual for a given commmand"
			echo "reboot    - reboot the system"
			echo "shutdown  - shutdown the system"
			echo "system    - checks systems current status"
			echo "version   - display version of the 'Central Park Control Console' (cpcc)"
			echo "quit      - quit the console"
			;;
		[Gg]*)	top ;;
		man*)
			case $m in
				*access)
					echo "SYNOPSIS"
					echo "        access [SYSTEM_NAME] [MAGIC_WORD]"
					echo ""
					echo "DESCRIPTION"
					echo "        Gain read and write access to a specified environment."
					echo ""
					echo "SYSTEM_NAME"
					echo "        Available SYSTEM_NAMES are:"
					echo "        - 'securtiy',"
					echo "        - 'securtiy grid' and"
					echo "        - 'main securtiy grid'."
					echo ""
					echo "EXAMPLES"
					echo "        access main security grid"
					echo ""
					echo "AUTHOR"
					echo "        Written by Dennis Nedry."
					;;
				*clear)
					echo "SYNOPSIS"
					echo "        clear"
					echo ""
					echo "DESCRIPTION"
					echo "        Clears the screen und return a pure prompt."
					echo ""
					echo "AUTHOR"
					echo "        Written by Dennis Nedry."
					;;
				*display)
					echo "SYNOPSIS"
					echo "        display file"
					echo ""
					echo "DESCRIPTION"
					echo "        Displays a commmand summary for the 'Central Park Control Console'"
					echo "        (cpcc) of the Jurassic Systems."
					echo ""
					echo "AUTHOR"
					echo "        Written by Torbjorn Granlund and Richard M. Stallman."
					;;
				*gr_osview)
					echo "SYNOPSIS"
					echo "        gr_osview"
					echo ""
					echo "DESCRIPTION"
					echo "        Displays system processes."
					echo ""
					echo "AUTHOR"
					echo "        Written by Dennis Nedry."
					;;
				*help)
					echo "SYNOPSIS"
					echo "        help"
					echo ""
					echo "DESCRIPTION"
					echo "        Displays a file of an entered name."
					echo ""
					echo "AUTHOR"
					echo "        Written by Dennis Nedry."
					;;
				*keychecks)
					echo "SYNOPSIS"
					echo "        keychecks"
					echo ""
					echo "DESCRIPTION"
					echo "        A system level command log used for accountability purposes."
					echo "        keychecks must be activated or deactivated via the main board."
					echo ""
					echo "AUTHOR"
					echo "        Written by Dennis Nedry."
					;;
				*ls)
					echo "SYNOPSIS"
					echo "        ls [FILE] ..."
					echo ""
					echo "DESCRIPTION"
					echo "        Lists information about the FILEs (the current directory by default)."
					echo ""
					echo "AUTHOR"
					echo "        Written by Richard M. Stallman and David MacKenzie."
					;;
				man)
					case $sh in
						u)	echo $EB"What manual page do you want?" ;;
						*)	echo -e $EB"What manual page do you want?" ;;
					esac
					;;
				*man)
					echo "SYNOPSIS"
					echo "        man title"
					echo ""
					echo "DESCRIPTION"
					echo "        man locates and prints the titled entries from the on-line reference"
					echo "        manuals."
					echo ""
					echo "AUTHOR"
					echo "        Written by Dennis Nedry."
					;;
				*reboot)
					echo "SYNOPSIS"
					echo "        reboot"
					echo ""
					echo "DESCRIPTION"
					echo "        Reboots the system.  Deactivates the security grid temporarily."
					echo ""
					echo "AUTHOR"
					echo "        Written by Dennis Nedry."
					;;
				*shutdown)
					echo "SYNOPSIS"
					echo "        shutdown"
					echo ""
					echo "DESCRIPTION"
					echo "        Halts the system and shuts it down. Deactivates the security grid"
					echo "        permanently."
					echo ""
					echo "AUTHOR"
					echo "        Written by Dennis Nedry."
					;;
				*system)
					echo "SYNOPSIS"
					echo "        system [SYSTEM_NAME]"
					echo ""
					echo "DESCRIPTION"
					echo "        Check the input system and return each sector's current status."
					echo ""
					echo "AUTHOR"
					echo "        Written by Dennis Nedry."
					;;
				*version)
					echo "SYNOPSIS"
					echo "        version"
					echo ""
					echo "DESCRIPTION"
					echo "        Displays system version, the author and copyright informations."
					echo ""
					echo "AUTHOR"
					echo "        Written by Marc Fege.  Inspired by 'jurassicsystems.com' of"
					echo "        Tully Robinson."
					;;
				*quit)
					echo "SYNOPSIS"
					echo "        quit"
					echo ""
					echo "DESCRIPTION"
					echo "        Quits the 'Central Park Control Console' (cpcc)."
					echo ""
					echo "AUTHOR"
					echo "        Written by Dennis Nedry."
					;;
				*)
					case $sh in
						u)	echo $EB"No manual entry for $m" ;;
						*)	echo -e $EB"No manual entry for $m" ;;
					esac
					;;
			esac
			;;
		reboot)
			echo "WARNING: security grid shutdown initiated!"
			case $sh in
				u)	echo $EB"System reboot...\c" ;;
				b)	echo -e $EBB ; echo -n "System reboot..." ;;
				*)	echo -en $EB"System reboot..." ;;
			esac
			sleep 3
			echo ""
			case $sh in
				u)	echo "Security              ![OFF]\c" ;;
				*)	echo -n "Security              ![OFF]" ;;
			esac
			sleep 2
			echo ""
			case $sh in
				u)	echo "Fence                 ![OFF]\c" ;;
				*)	echo -n "Fence                 ![OFF]" ;;
			esac
			sleep 2
			echo ""
			case $sh in
				u)	echo "Feeding Pavilion      ![OFF]\c" ;;
				*)	echo -n "Feeding Pavilion      ![OFF]" ;;
			esac
			sleep 2
			echo ""
			case $sh in
				u)	echo $EB"Rebooting...\c" ;;
				b)	echo -e $EBB ; echo -n "Rebooting..." ;;
				*)	echo -ne $EB"Rebooting..." ;;
			esac
			sleep 2
			echo ""
			m=
			ks=
			clear
			sleep 3
			case $sh in
				u)	echo "Feeding Pavilion        [ON]\c" ;;
				*)	echo -n "Feeding Pavilion        [ON]" ;;
			esac
			sleep 2
			echo ""
			case $sh in
				u)	echo "Fence                   [ON]\c" ;;
				*)	echo -n "Fence                   [ON]" ;;
			esac
			sleep 2
			echo ""
			case $sh in
				u)	echo "Security                [ON]\c" ;;
				*)	echo -n "Security                [ON]" ;;
			esac
			sleep 2
			echo ""
			case $sh in
				u)	echo "security grid       [online]\c" ;;
				*)	echo -n "security grid       [online]" ;;
			esac
			sleep 2
			echo ""
			clear
			case $sh in
				u)	echo $EB"System Ready \c" ;;
				b)	echo -e $EBB ; echo -n "System Ready " ;;
				*)	echo -ne $EB"System Ready " ;;
			esac
			;;
		shutdown)
			echo "WARNING: security grid final shutdown initiated!"
			case $sh in
				u)	echo $EB"System shutdown...\c" ;;
				b)	echo -e $EBB ; echo -n "System shutdown..." ;;
				*)	echo -en $EB"System shutdown..." ;;
			esac
			sleep 3
			echo ""
			case $sh in
				u)	echo "Security              ![OFF]\c" ;;
				*)	echo -n "Security              ![OFF]" ;;
			esac
			sleep 2
			echo ""
			case $sh in
				u)	echo "Fence                 ![OFF]\c" ;;
				*)	echo -n "Fence                 ![OFF]" ;;
			esac
			sleep 2
			echo ""
			case $sh in
				u)	echo "Feeding Pavilion      ![OFF]\c" ;;
				*)	echo -n "Feeding Pavilion      ![OFF]" ;;
			esac
			sleep 2
			echo ""
			case $sh in
				u)	echo $EB"System Halt!\c" ;;
				b)	echo -e $EBB ; echo -n "System Halt!" ;;
				*)	echo -ne $EB"System Halt!" ;;
			esac
			sleep 3
			echo ""
			exit 1
			;;
		system*)
			case $m in
				system) 	echo $m$ES ;;
				*)
					em=$(echo $m | cut -f -2 -d ' ')
					case $sh in
						u)	echo $EB$em" containment enclosure...\c" ;;
						b)	echo -e $EBB ; echo -n "containment enclosure..." ;;
						*)	echo -en $EB$em" containment enclosure..." ;;
					esac
					sleep 2
					echo ""
					case $sh in
						u)	echo "Security                [OK]\c" ;;
						*)	echo -n "Security                [OK]" ;;
					esac
					sleep 1
					echo ""
					case $sh in
						u)	echo "Fence                   [OK]\c" ;;
						*)	echo -n "Fence                   [OK]" ;;
					esac
					sleep 1
					echo ""
					case $sh in
						u)	echo "Feeding Pavilion        [OK]\c" ;;
						*)	echo -n "Feeding Pavilion        [OK]" ;;
					esac
					sleep 1
					echo ""
					case $sh in
						u)	echo $EB"System Halt!\c" ;;
						b)	echo -e $EBB ; echo -n "System Halt!" ;;
						*)	echo -ne $EB"System Halt!" ;;
					esac
					sleep 2
					echo ""
					;;
			esac
			;;
		[Vv]*)
			FuncVer
			echo $CP
			;;
		42|[Ww][Gg]|[Ww]argames)
			case $sh in
				u)	echo $EB"SHALL WE PLAY A GAME?\c" ;;
				b)	echo -e $EBB ; echo -n "SHALL WE PLAY A GAME?" ;;
				*)	echo -ne $EB"SHALL WE PLAY A GAME?" ;;
			esac
			case $sh in
				b|"")	read -p " " wg ;;
				u)	echo " \c" ; read wg ;;
			esac
			sleep 3
			case $sh in
				u)	echo $EB"A STRANGE GAME.\c" ;;
				b)	echo -e $EBB ; echo -n "A STRANGE GAME." ;;
				*)	echo -ne $EB"A STRANGE GAME." ;;
			esac
			sleep 3
			echo ""
			case $sh in
				u)	echo "THE ONLY WINNING MOVE IS\c" ;;
				*)	echo -n "THE ONLY WINNING MOVE IS" ;;
			esac
			sleep 2
			echo ""
			case $sh in
				u)	echo "NOT TO PLAY.\c" ;;
				*)	echo -n "NOT TO PLAY." ;;
			esac
			sleep 2
			echo ""
			wg=
			;;
		*)	sleep 1
			case $sh in
				u)	echo $EB$m": command not found" ;;
				*)	echo -e $EB$m": command not found" ;;
			esac
			;;
	esac
	ks=$(echo $ks $m)
done
;;
	*)	 echo "$EA" >&2 ; FuncHelpShort >&2 ; exit 1 ;;
esac
fi
